class MyAuthenticationForm(BetterForm):
	"""
	Base class for authenticating users. Extend this to get a form that accepts
	username/password logins.
	"""
	username = forms.CharField(label=_("Username"), max_length=30)
	password = forms.CharField(label=_("Password"), widget=forms.PasswordInput)

	class Meta:

		fieldsets=((u'login',{'fields':('username','password'),'legend':'','description':_("Please, enter with your username and password:")}),)

	def __init__(self, request=None, *args, **kwargs):
		"""
		If request is passed in, the form will validate that cookies are
		enabled. Note that the request (a HttpRequest object) must have set a
		cookie with the key TEST_COOKIE_NAME and value TEST_COOKIE_VALUE before
		running this validation.
		"""
		self.request = request
		self.user_cache = None
		super(MyAuthenticationForm, self).__init__(*args, **kwargs)

	def clean(self):
		username = self.cleaned_data.get('username')
		password = self.cleaned_data.get('password')

		if username and password:
			self.user_cache = authenticate(username=username, password=password)
		if self.user_cache is None:
			raise forms.ValidationError(_("Please enter a correct username and password. Note that both fields are case-sensitive."))
		elif not self.user_cache.is_active:
			raise forms.ValidationError(_("This account is inactive."))

		# TODO: determine whether this should move to its own method.
		if self.request:
			if not self.request.session.test_cookie_worked():
				raise forms.ValidationError(_("Your Web browser doesn't appear to have cookies enabled. Cookies are required for logging in."))

		return self.cleaned_data

	def get_user_id(self):
		if self.user_cache:
			return self.user_cache.id
		return None

	def get_user(self):
		return self.user_cache
