from django.test import TestCase
from vertimus.models import ActionDb

class VertimusTest(TestCase):
    fixtures = ['bug-mysql.json']

    def test_mysql(self):
        actions_db = ActionDb.objects.filter(state_db__id=1).exclude(name='WC').order_by('-id')

        # So the last action is UNDO
        # but 'RT' is returned!
        self.assertEqual(actions_db[0].name, 'UNDO')
        # Here be dragons! A call to len() workaround the bug (try to move it)!
        len(actions_db)
        self.assertEqual(actions_db[0].name, 'UNDO')
