from django.core.template import Library, Node, TemplateSyntaxError,
resolve_variable
register = Library()

@register.tag(name="cache")
def do_cache(parser, token):
    nodelist = parser.parse(('endcache',))

    parser.delete_first_token()

    args = token.contents.split()
    if len(args) >= 3:
        tag_name, expire_time, fragment_name = args[:3]
        id_names = args[3:]
    else:
        raise TemplateSyntaxError("Invalid arguments to cache: %s" % args)

    return CacheNode(nodelist, expire_time, fragment_name, id_names)

class CacheNode(Node):
    def __init__(self, nodelist, expire_time, fragment_name, id_names):
        self.nodelist = nodelist
        self.expire_time = expire_time
        self.fragment_name = fragment_name
        self.id_names = id_names

    def render(self, context):
        cache_id = self.fragment_name
        for id_name in self.id_names:
            cache_id += ":%s" % resolve_variable(id_name, context)

        from django.core.cache import cache
        value = cache.get(cache_id)

        if not value:
            value = self.nodelist.render(context)
            cache.set(cache_id, value, float(self.expire_time))

        return value