from django.db import models
from django.contrib import admin

class Animal(models.Model):
    name=models.CharField('Name', max_length=255,)
    class Meta:
        verbose_name=('Animal')
        verbose_name_plural=('Mentor Nodes')
        ordering=['name',]

class Person(Animal):
    class Meta:
        verbose_name=('Person')
        verbose_name_plural=('People')

class Pet(Animal):
    class Meta:
        verbose_name=('Pet')
        verbose_name_plural=('Pets')

class House(models.Model):
    owner=models.ForeignKey(
        Person,
        verbose_name='Owner',
        null=True,
        blank=True,
    )
    pet=models.ForeignKey(
        Pet,
        verbose_name='Pet',
        null=True,
        blank=True,
    )

    class Meta:
        verbose_name=('House')
        verbose_name_plural=('Houses')
        ordering=['owner','pet']

# register all models for django admin
class HouseAdmin(admin.ModelAdmin):
    list_display = ('owner','pet')
admin.site.register(House, HouseAdmin)
