from django.db.models.query import Q

class hacked_Q_for_isnull(Q):
    """
    Q object that forces all joins to be LEFT JOINs.  This is necessary
    in the case of a filter for foo_isnull=True.
    
    For a bit more detail, see ticket #1050
        http://code.djangoproject.com/ticket/1050
    
    Example usage:
        Foo.objects.filter(hacked_Q_for_isnull(bar__isnull=True))
    
    Note:
        The above usage is the only one that's been tested.  Even so,
        this is an ugly approach but I hope it will be enough until the
        QuerySet refactor is completed.
    """
    def get_sql(self, opts):
        results = super(hacked_Q_for_isnull, self).get_sql(opts)
        new_results = []
        for d in results:
            if isinstance(d, dict):
                temp = {}
                for k,v in d.items():
                    temp_list = list(v)
                    temp_list[1] = 'LEFT JOIN'
                    temp[k] = temp_list
                d=temp
            new_results.append(d)
        return new_results
