from django.core.mail.backends.base import BaseEmailBackend
from django.utils.encoding import force_unicode

from mailer import PRIORITY_MAPPING
from mailer.models import Message


class EmailBackend(BaseEmailBackend):

    def __init__(self, *args, **kwds):
        if 'priority' in kwds:
            self.priority = kwds.pop('priority')
        else:
            self.priority = 'medium'
        super(EmailBackend, self).__init__(*args, **kwds)

    def _store_message(self, message):
        subject = force_unicode(message.subject)
        priority = PRIORITY_MAPPING[self.priority]
        for to_address in message.recipients():
            Message(to_address=to_address,
                    from_address=message.from_email,
                    subject=subject,
                    message_body=message.body,
                    priority=priority).save()

    def send_messages(self, email_messages):
        num_sent = 0
        for message in email_messages:
            try:
                self._store_message(message)
                num_sent += 1
            except:
                if not self.fail_silently:
                    raise
        return num_sent
