from django.test import TestCase

class SimpleTest(TestCase):
	def test_template_timestamp(self):
		from datetime import datetime
		from django.template import Context, Template
		now = datetime.now()
		t = Template('{{ now|date:"U" }}')
		c = Context({'now': now})	   
		self.failUnlessEqual(int(now.strftime('%s')), int(t.render(c)))
	
	def test_template_rawdate(self):
		from datetime import datetime
		from django.template import Context, Template
		now = datetime.now()
		t = Template('{{ now|date:"Y-m-d H:i:s" }}')
		c = Context({'now': now})
		self.failUnlessEqual(now.strftime('%F %T') ,t.render(c))
		


