from django.db import models

class Category(models.Model):
    name = models.CharField(max_length=100)
    description = models.CharField(blank=True, null=True)
    order = models.IntegerField(unique=True)

    def __unicode__(self):
        return self.name

    class Meta:
        ordering = ['order']
        verbose_name_plural = 'categories'

class Link(models.Model):
    name = models.CharField(max_length=100)
    description = models.CharField(blank=True, null=True)
    target = models.URLField(verify_exists=False)
    favorite = models.BooleanField()
    category = models.ForeignKey(Category)

    def __unicode__(self):
        return self.name

    class Meta:
        ordering = [ '?' ]
