from links.models import Category, Link
from django.contrib import admin

class LinkInline(admin.StackedInline):
    model = Link
    extra = 3

class CategoryOptions(admin.ModelAdmin):
    list_display = ('name','order','description')

    inlines = [LinkInline]

admin.site.register(Category, CategoryOptions)

