import datetime
from django.test import TestCase
from django.db.models import Count
from library.models import Publisher


class AnnotateTest(TestCase):

    def setUp(self):
        self.A = Publisher.objects.create(name='A', num_awards=20)
        self.B = Publisher.objects.create(name='B', num_awards=21)
        self.A.book_set.create(name='a1', pages=200, price='9.99', rating=4,
            pubdate=datetime.datetime.now())
        self.A.book_set.create(name='a2', pages=200, price='12.99', rating=5,
            pubdate=datetime.datetime.now())
        self.A.book_set.create(name='a3', pages=200, price='2.99', rating=1,
            pubdate=datetime.datetime.now())

    def test_sanity(self):
        self.assertEqual(self.A.book_set.count(), 3)
        self.assertEqual(self.A.book_set.filter(rating__gt=3.0).count(), 2)

    def test_annotate_first(self):
        qs = Publisher.objects.all()
        qs = qs.annotate(num_books=Count('book'))
        qs = qs.filter(book__rating__gt=3.0)
        pub = qs[0]
        print qs.values('num_books').query
        self.assertEqual(pub, self.A)
        self.assertEqual(pub.num_books, 3)

    def test_filter_first(self):
        qs = Publisher.objects.all()
        qs = qs.filter(book__rating__gt=3.0)
        qs = qs.annotate(num_books=Count('book'))
        pub = qs[0]
        self.assertEqual(pub, self.A)
        self.assertEqual(pub.num_books, 2)
