using System;
using System.Collections;
using System.Collections.Specialized;

using Nii.JSON;

namespace Nii.JSON.Console
{
	/// <summary>
	/// Summary description for Driver.
	/// </summary>
	class Driver
	{
		// See also json.txt for a more readable version
		public static readonly string sTest = 
		@"{
    'this test'  : true,
    'ThreeDSort' : {
        z : 9.323
    },
    'x y' : 'x y',
    yPos  : {
        'inner'  : [2,4],
        'outer'  : [4,8,4,8]
    },
    'props': [ true, null, false],
    'oldVals': [ 'oldvals1', {innermost:'old+inner'}, 'oldvals3'],
    y1   : {
        z  : 'value'
    },
    'xy and z': 'xy and z',
    y3   : {
        z2  : 'z2'
    }
};";

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{
			Driver instance = new Driver();
			instance.Run();
		}

		/// <summary>
		/// Run the instance
		/// </summary>
		public void Run()
		{
			System.Console.WriteLine("Simple roundtrip demonstration of using the JSON lib");
			System.Console.WriteLine("Task #1. Parse the JSON formattet string into a Hashtable");
			///<summary>parse the JSON formatted object sTest</summary>
			IDictionary idict =  fromJSON(sTest);

			///<summary>
			///Make the roundtrip.
			/// Copy results and validate with 
			/// http://www.crockford.com/javascript/jslint.html
			/// NOTE! prefix results with a foo = {};
			/// Omit the hashtable echo!
			///</summary>
			string sJSON = toJSON(idict);
			System.Console.WriteLine("\nTask# 2. Convert the Hashtable back into a JSON formattet string");
			System.Console.WriteLine(sJSON);

			
			System.Console.WriteLine("================================================");
			System.Console.WriteLine("Task# 4. Construct a JSON object dynamically");
			System.Console.WriteLine("------------------------------------------------");
			JSONObject jso = new JSONObject();
			jso.put("this test",true);
			jso.put("ThreeDSort",new JSONObject().put("z",9.323));
			jso.put("x y","x y");
			jso.accumulate("inner", 2);
			jso.accumulate("inner", 4);
			jso.accumulate("outer",4);
			jso.accumulate("outer",8);
			jso.accumulate("outer",4);
			jso.accumulate("outer",8);
			jso.accumulate("props",true);
			jso.accumulate("props",null);
			jso.accumulate("props",false);
			jso.accumulate("oldvals","oldvals1");
			jso.accumulate("oldvals", new JSONObject().put("innermost","old+inner"));
			jso.accumulate("oldvals","oldvals3");
			jso.accumulate("y1", new JSONObject().put("z","value"));
			jso.accumulate("xy and z","xy and z");
			jso.accumulate("y3", new JSONObject().put("z2","z2"));
			System.Console.WriteLine(jso.ToString());
			System.Console.WriteLine("==========================================");
			JSONObject jso2 = new JSONObject(jso.getDictionary());
			System.Console.WriteLine(jso2.ToString());      
			System.Console.WriteLine("==========================================");
			System.Console.WriteLine("Iterating through the JSON object using an indexer, and returning keys");
			for (int i=0; i<jso2.Count; i++)
				System.Console.WriteLine(jso2[i]);
			System.Console.WriteLine("==========================================");
			System.Console.WriteLine("Using the indexer, to retrive keys and then values");
			for (int i=0; i<jso2.Count; i++)
				System.Console.WriteLine("index={0},\tKey={1},\t\tValue={2}",i,jso2[i],jso2[jso2[i]]);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		protected string toJSON(IDictionary idict)
		{
			return JsonFacade.toJSON(idict);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sJSON"></param>
		/// <returns></returns>
		protected IDictionary fromJSON(string sJSON)
		{
			IDictionary idict = JsonFacade.fromJSON(sJSON);
			PrintKeysAndValues(idict);
			return idict;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="myCol"></param>
		public static void PrintKeysAndValues( IEnumerable myCol )  
		{
			IEnumerator myEnumerator = myCol.GetEnumerator();
			System.Console.WriteLine( "   KEY                       VALUE" );
			foreach ( DictionaryEntry de in myCol )
			{
				System.Console.WriteLine( "   {0,-25} {1}", de.Key, de.Value );
			}
			System.Console.WriteLine();
		}
	}
}
