
'''
Functions for reading, writing and displaying debugging messages.

This program writes debugging messages to a text file. In order to
do this, the program must know where to write this file and have write
privelges to the folder that will contain this file.

To accomplish this, put a variable in your settings.py folder called 
DEBUG_MESSAGES_ROOT. Set this variable to the path to the folder where
you want to write the message file. This is what I have in my settings.py
file:

DEBUG_MESSAGES_ROOT=r'C:\Documents and Settings\CCM\Desktop\pldev\debug_messages'

Note the last item is a folder name and there is no trailing separator.

To write debugging messages, in the file where you want to create
messages put:

import debug_messages.views as dbm

To post a message call the function:

dbm.write(your message)

To enable viewing of the files, add to your urls.py:

(r'^debug_messages/$', 'yourproject.debug_messages.views.index')

Finally, to view the messages, pointer your browser to
/debug_messages/

You can clear the file by using the "Clear" button on this web page, or
by deleting the file.
'''

from django.shortcuts import render_to_response
from django.conf import settings
import os
import os.path
from datetime import datetime

#------------------------------------------------------------------
# Functions for managing the message file. "write" is the only function
# you will need to directly access.

def write(message):
    fp=file(get_filename(),'a+')
    fp.write(str(datetime.now())+':  '+message)
    fp.close()

def get_filename():
    return os.path.join(settings.DEBUG_MESSAGES_ROOT,'messages.txt')

def clear():
    fname=get_filename()
    if os.path.exists(fname):
        os.remove(fname)

def read():
    fname=get_filename()
    if not os.path.exists(fname):
        return ['No Messages.']
    
    fp=file(fname,'r')
    the_messages=fp.readlines()
    fp.close()
    return the_messages
  
#------------------------------------------------------------------
# The view for displaying the messages and clearing the message file.
def index(request):

    if request.POST.get('clear','')=='clear':
        clear()
        messages=['No Messages.']
    else:
        messages=read()

    return render_to_response("debug_messages.html",\
                              {'messages':messages,
                               'site_url':settings.SITE_URL})


