from optparse import OptionParser
import sys
import os

try:
    import settings
except ImportError:
    print "Settings file not found. Place this file in the same dir as manage.py"
    sys.exit()

project_directory = os.path.dirname(settings.__file__)
project_name = os.path.basename(project_directory)
sys.path.append(os.path.join(project_directory, ".."))
project_module = __import__(project_name, '', '', [''])
sys.path.pop()
os.environ['DJANGO_SETTINGS_MODULE'] = "%s.settings" % project_name

from django.newforms import form_for_model

p = OptionParser()

p.add_option("-a", "--app", dest="app", help="The app which contains the model")
p.add_option("-m", "--model", dest="model", help="The model to produce the Form for")

options, args = p.parse_args()

if not(options.model and options.app):
    p.print_help()
    sys.exit()

m = __import__("%s.%s.models" % (project_name, options.app,), '', '', [options.model])

a = getattr(m, options.model)

fields = a._meta.fields + a._meta.many_to_many

print "class %sForm(forms.Form):" % (options.model)
for f in fields:
    formfield = f.formfield()
    if formfield:
        fieldtype = formfield.__str__().split(".")[3].split(" ")[0]
        print "    %s = forms.%s()" % (f.name, fieldtype)
