// ==UserScript==
// @name           DjangoPasswordHasher
// @namespace      http://svn.ambitone.com/ambidjangolib
// @description    Converts plaintext passwords to salted sha1 hashes in Django auth admin
// @include        *
// ==/UserScript==

/*
 * DjangoPasswordHasher greasemonkey user script
 * Version 1.0  Antti Kaihola 2006 <akaihola@ambitone.com>
 */


/*
 * SHA-1 algorithm adapted from:
 *
 * A JavaScript implementation of the Secure Hash Algorithm, SHA-1, as defined
 * in FIPS PUB 180-1
 * Version 2.1a Copyright Paul Johnston 2000 - 2002.
 * Other contributors: Greg Holt, Andrew Kepert, Ydnar, Lostinet
 * Distributed under the BSD License
 * See http://pajhome.org.uk/crypt/md5 for details.
 */

var chrsz = 8;

function hex_sha1(s) { return binb2hex(core_sha1(str2binb(s),s.length * chrsz)); }

function core_sha1(x, len) {
  x[len >> 5] |= 0x80 << (24 - len % 32);
  x[((len + 64 >> 9) << 4) + 15] = len;
  var w = Array(80);
  var a =  1732584193;
  var b = -271733879;
  var c = -1732584194;
  var d =  271733878;
  var e = -1009589776;
  for(var i = 0; i < x.length; i += 16) {
    var olda = a; var oldb = b; var oldc = c; var oldd = d; var olde = e;
    for(var j = 0; j < 80; j++) {
      if (j < 16) w[j] = x[i + j];
      else w[j] = rol(w[j-3] ^ w[j-8] ^ w[j-14] ^ w[j-16], 1);
      var t = safe_add(safe_add(rol(a, 5), sha1_ft(j, b, c, d)),
                       safe_add(safe_add(e, w[j]), sha1_kt(j)));
      e = d; d = c; c = rol(b, 30); b = a; a = t; }
    a = safe_add(a, olda);
    b = safe_add(b, oldb);
    c = safe_add(c, oldc);
    d = safe_add(d, oldd);
    e = safe_add(e, olde); }
  return Array(a, b, c, d, e); }

function sha1_ft(t, b, c, d) {
  if (t < 20) return (b & c) | ((~b) & d);
  if (t < 40) return b ^ c ^ d;
  if (t < 60) return (b & c) | (b & d) | (c & d);
  return b ^ c ^ d; }

function sha1_kt(t) {
  return (t < 20) ?  1518500249 : (t < 40) ?  1859775393 :
         (t < 60) ? -1894007588 : -899497514; }

function safe_add(x, y) {
  var lsw = (x & 0xFFFF) + (y & 0xFFFF);
  var msw = (x >> 16) + (y >> 16) + (lsw >> 16);
  return (msw << 16) | (lsw & 0xFFFF); }

function rol(num, cnt) {
  return (num << cnt) | (num >>> (32 - cnt)); }

function str2binb(str) {
  var bin = Array();
  var mask = (1 << chrsz) - 1;
  for (var i = 0; i < str.length * chrsz; i += chrsz)
    bin[i>>5] |= (str.charCodeAt(i / chrsz) & mask) << (32 - chrsz - i%32);
  return bin; }

function binb2hex(binarray) {
  var hex_tab = "0123456789abcdef";
  var str = "";
  for(var i = 0; i < binarray.length * 4; i++)
    str += hex_tab.charAt((binarray[i>>2] >> ((3 - i%4)*8+4)) & 0xF) +
           hex_tab.charAt((binarray[i>>2] >> ((3 - i%4)*8  )) & 0xF);
  return str; }

/* SHA-1 algorithm ends here */




function process_password_field(e) { 
  /* Imitate django.contrib.auth.models.User.set_password() */
  var pw = e.target.value;
  if (pw.substr(0, 5) != 'sha1$' && pw.substr(0, 4) != 'md5$') {
    var salt = hex_sha1(Math.random().toString()).substr(0, 5);
    e.target.value = 'sha1$' + salt + '$' + hex_sha1(salt + pw); }
}



window.addEventListener("load", function(e) {
  /* identify Django auth User admin password field     *
   * and add password processing when field loses focus */
  var pwinput = document.getElementById('id_password');
  if (pwinput 
      && pwinput.className == 'vTextField required' 
      && pwinput.name == 'password'
      && pwinput.size == 30
      && pwinput.getAttribute('maxlength') == 128) {
    pwinput.addEventListener('blur', process_password_field, true);
  }
}, false);


