from django.core import validators
from django import forms
import re

slug_ignore= ( "a", "an", "as", "at", "before", "but", "by", "for", "from",
                    "is", "in", "into", "like", "of", "off", "on", "onto", "per",
                    "since", "than", "the", "this", "that", "to", "up", "via",
                    "with" )
slug_first = re.compile('\\b(%s)\\b' % '|'.join(slug_ignore))
slug_second = re.compile('\s+')
slug_third = re.compile('[^\\w-]')
slug_fourth = re.compile('--+')
def slugify(value, max=None):
    """
    Returns a slug based on the given value.  If 'max' is given,
    the slug will not be any longer than 'max'.
    """
    value = value.strip().lower()  
    value = slug_first.sub('', value).strip() # Remove any of the slug_ignore words.
    value = slug_second.sub('-', value)     # Replace any white-space with a single dash.
    value = slug_third.sub('', value)          # Remove anything that is not a letter or a dash.
    value = slug_fourth.sub('-', value)      # Replace any series of dashes with a single dash.
    if (max):
        return value[:max]
    else:
        return value


class Manipulator(forms.Manipulator):    
    def __init__(self, *args, **kw):
        self.form = False
        self.default = {}
        self.fields = ()
        return self.init(*args, **kw)
    
    def _get_data(self, request):
        return request.POST
    
    def _get_form(self, data, errors):
        return forms.FormWrapper(self, data, errors)
    
    def process(self, request):
        data = self._get_data(request)
        if data:
            new_data = data.copy()
            errors = self.get_validation_errors(new_data)
            if not errors:
                self.do_html2python(new_data)
                
                return self.complete(request, new_data)                
        else:
            errors = {}
            new_data = self.default
        self.form = self._get_form(new_data, errors)
        return self.form

    def complete(self, request, data):
        "This should be over-ridden."
        pass
    
    def init(self):
        "This should also be over-ridden."
        pass
        
class GETManipulator(Manipulator):
    def _get_data(self, request):
        return request.GET
