from django.conf.urls.defaults import *
from django.contrib import admin
from watusee.work.models import Project

admin.autodiscover()

work_dict= {
    'queryset': Project.objects.all(),
    'extra_context' : {
        'worksnav' : Project.objects.filter(publish=True),
    }
}

urlpatterns = patterns('',
#    (r'^works/$', 'django.views.generic.list_detail.object_list', dict(work_dict, template_name='works.html', template_object_name='works')),
    (r'^works/(?P<slug>[-\w]+)/$', 'django.views.generic.list_detail.object_detail', dict(work_dict, slug_field='slug', template_name='work.html', template_object_name='work')),
    (r'^admin/(.*)', admin.site.root),
    (r'^site_media/(?P<path>.*)$', 'django.views.static.serve', {'document_root': '/home2/mainderay/webapps/site_media/'}),
    (r'', include('django.contrib.flatpages.urls')),

)
