from django.core import meta

class Picture(meta.Model):
    name = meta.CharField(maxlength=50)
    picture_width = meta.PositiveIntegerField(editable=False)
    picture_height = meta.PositiveIntegerField(editable=False)
    picture = meta.ImageField(width_field='picture_width', height_field='picture_height', upload_to='pictures/images')
    description = meta.TextField(blank=True, null=True)

    class META:
        admin = meta.Admin(
            fields = (
                (None, {'fields': ('name', 'description',)}),
            ),
            list_display  = ('name', 'description',),
            list_filter   = ('name',),
            ordering      = ('id',),
            search_fields = ['name', 'description',],
        )

    def __repr__(self):
        return self.name
