"""
Czech-specific form helpers
"""

from django.forms.fields import Select, RegexField
from django.utils.translation import ugettext_lazy as _

class CZRegionSelect(Select):
    """
    A select widget widget with list of Czech regions as choices.
    """
    def __init__(self, attrs=None):
        from cs_regions import REGION_CHOICES
        super(CZRegionSelect, self).__init__(attrs, choices=REGION_CHOICES)

class CZPostalCodeField(RegexField):
    """
    A form field that validates its input as Czech postal code.
    Valid form is XXXXX or XXX XX, where X represents integer.
    """
    default_error_messages = {
        'invalid': _(u'Enter a postal code in the format XXXXX or XXX XX.'),
    }

    def __init__(self, *args, **kwargs):
        super(CZPostalCodeField, self).__init__(r'^\d{5}$|^\d{3} \d{2}$',
            max_length=None, min_length=None, *args, **kwargs)

    def clean(self, value):
        """
        Validates the input and returns a string that contains only numbers.
        Returns an empty string for empty values.
        """
        v = super(CZPostalCodeField, self).clean(value)
        return v.replace(' ', '')
