from django.db import models

# Create your models here.
class Entry(models.Model):
    pub_date = models.DateTimeField('date published')
    created = models.DateTimeField(auto_now_add=True, editable=False)
    edited = models.DateTimeField(auto_now=True, editable=False)
    title = models.CharField(max_length=200, blank=True)
    title_fi = models.CharField(max_length=200, blank=True)
    is_memorial = models.BooleanField('Use special layout?', default=False)

class Image(models.Model):
    entry = models.ForeignKey(Entry, related_name='images')
    file = models.ImageField(upload_to="%Y")
    caption = models.TextField()
    caption_fi = models.TextField()
