from django.db import models
from django.contrib import admin
from django import forms

class Poll(models.Model):
    question = models.CharField(max_length=200)
    pub_date = models.DateTimeField('date published')

class Choice(models.Model):
    poll = models.ForeignKey(Poll)
    choice = models.CharField(max_length=200)
    votes = models.IntegerField()


class MyModelForm(forms.ModelForm): pass

class MyWorkingModelFormMetaclass(forms.models.ModelFormMetaclass): #inheriting gets rid of a nasty metaclass conflict
    def __new__(cls, name, bases, attrs):
        formfield_callback = attrs.pop('formfield_callback',
                lambda f: f.formfield())
        try:
            parents = [b for b in bases if issubclass(b, MyWorkingModelForm)]
        except NameError:
            # We are defining MyWorkingModelForm itself.
            parents = None
        print repr(parents)
        new_class = super(MyWorkingModelFormMetaclass, cls).__new__(cls, name, bases,
                attrs)
        if not parents:
            return new_class

        if 'media' not in attrs:
            new_class.media = forms.models.media_property(new_class)
        declared_fields = forms.models.get_declared_fields(bases, attrs, False)
        opts = new_class._meta = forms.models.ModelFormOptions(getattr(new_class, 'Meta', None))
        if opts.model:
            # If a model is defined, extract form fields from it.
            fields = forms.models.fields_for_model(opts.model, opts.fields,
                                      opts.exclude, formfield_callback)
            # Override default model fields with any custom declared ones
            # (plus, include all the other declared fields).
            fields.update(declared_fields)
        else:
            fields = declared_fields
        new_class.declared_fields = declared_fields
        new_class.base_fields = fields
        return new_class

class MyWorkingModelForm(forms.BaseModelForm):
    __metaclass__ = MyWorkingModelFormMetaclass


class ChoiceInline(admin.StackedInline):
    model = Choice
    extra = 3

class PollAdmin(admin.ModelAdmin):
    # the following is the default-- I am simply making it explicit
    form = forms.ModelForm
    
    # uncomment this to cause this to break
    #form = MyModelForm
    
    # uncomment this to cause this to almost work again
    #form = MyWorkingModelForm
    
    fieldsets = [
        (None,               {'fields': ['question']}),
        ('Date information', {'fields': ['pub_date'], 'classes': ['collapse']}),
    ]
    inlines = [ChoiceInline]

admin.site.register(Poll, PollAdmin)
