# -*- coding: utf-8 -*-
'''
Dictionaries containing TERYT code and names of corresponding administrative
entities.

Provinces are also known as voivodships, counties as poviats, communes as
gminas.

Source: http://isip.sejm.gov.pl/servlet/Search?todo=open&id=WDU19981571031
'''

from django.utils.translation import ugettext_lazy

PL_PROVINCES = {
    '02': ugettext_lazy(u'dolnośląskie'),
    '04': ugettext_lazy(u'kujawsko-pomorskie'),
    '06': ugettext_lazy(u'lubelskie'),
    '08': ugettext_lazy(u'lubuskie'),
    '10': ugettext_lazy(u'łódzkie'),
    '12': ugettext_lazy(u'małopolskie'),
    '14': ugettext_lazy(u'mazowieckie'),
    '16': ugettext_lazy(u'opolskie'),
    '18': ugettext_lazy(u'podkarpackie'),
    '20': ugettext_lazy(u'podlaskie'),
    '22': ugettext_lazy(u'pomorskie'),
    '24': ugettext_lazy(u'śląskie'),
    '26': ugettext_lazy(u'świętokrzyskie'),
    '28': ugettext_lazy(u'warmińsko-mazurskie'),
    '30': ugettext_lazy(u'wielkopolskie'),
    '32': ugettext_lazy(u'zachodniopomorskie'),
}

PL_COUNTIES = {
    '0201': u'bolesławiecki',
    '0202': u'dzierżoniowski',
    '0203': u'głogowski',
    '0204': u'górowski',
    '0205': u'jaworski',
    '0206': u'jeleniogórski',
    '0207': u'kamiennogórski',
    '0208': u'kłodzki',
    '0209': u'legnicki',
    '0210': u'lubański',
    '0211': u'lubiński',
    '0212': u'lwówecki',
    '0213': u'milicki',
    '0214': u'oleśnicki',
    '0215': u'oławski',
    '0216': u'polkowicki',
    '0217': u'strzeliński',
    '0218': u'średzki',
    '0219': u'świdnicki',
    '0220': u'trzebnicki',
    '0221': u'wałbrzyski',
    '0222': u'wołowski',
    '0223': u'wrocławski',
    '0224': u'ząbkowicki',
    '0225': u'zgorzelecki',
    '0226': u'złotoryjski',
    '0261': u'Jelenia Góra',
    '0262': u'Legnica',
    '0264': u'Wrocław',
    '0401': u'aleksandrowski',
    '0402': u'brodnicki',
    '0403': u'bydgoski',
    '0404': u'chełmiński',
    '0405': u'golubsko-dobrzyński',
    '0406': u'grudziądzki',
    '0407': u'inowrocławski',
    '0408': u'lipnowski',
    '0409': u'mogileński',
    '0410': u'nakielski',
    '0411': u'radziejowski',
    '0412': u'rypiński',
    '0413': u'sępoleński',
    '0414': u'świecki',
    '0415': u'toruński',
    '0416': u'tucholski',
    '0417': u'wąbrzeski',
    '0418': u'włocławski',
    '0419': u'żniński',
    '0461': u'Bydgoszcz',
    '0462': u'Grudziądz',
    '0463': u'Toruń',
    '0464': u'Włocławek',
    '0601': u'bialski',
    '0602': u'biłgorajski',
    '0603': u'chełmski',
    '0604': u'hrubieszowski',
    '0605': u'janowski',
    '0606': u'krasnostawski',
    '0607': u'kraśnicki',
    '0608': u'lubartowski',
    '0609': u'lubelski',
    '0610': u'łęczyński',
    '0611': u'łukowski',
    '0612': u'opolski',
    '0613': u'parczewski',
    '0614': u'puławski',
    '0615': u'radzyński',
    '0616': u'rycki',
    '0617': u'świdnicki',
    '0618': u'tomaszowski',
    '0619': u'włodawski',
    '0620': u'zamojski',
    '0661': u'Biała Podlaska',
    '0662': u'Chełm',
    '0663': u'Lublin',
    '0664': u'Zamość',
    '0801': u'gorzowski',
    '0802': u'krośnieński',
    '0803': u'międzyrzecki',
    '0804': u'nowosolski',
    '0805': u'słubicki',
    '0806': u'strzelecko-drezdenecki',
    '0807': u'sulęciński',
    '0808': u'świebodziński',
    '0809': u'zielonogórski',
    '0810': u'żagański',
    '0811': u'żarski',
    '0812': u'wschowski',
    '0861': u'Gorzów Wielkopolski',
    '0862': u'Zielona Góra',
    '1001': u'bełchatowski',
    '1002': u'kutnowski',
    '1003': u'łaski',
    '1004': u'łęczycki',
    '1005': u'łowicki',
    '1006': u'łódzki wschodni',
    '1007': u'opoczyński',
    '1008': u'pabianicki',
    '1009': u'pajęczański',
    '1010': u'piotrkowski',
    '1011': u'poddębicki',
    '1012': u'radomszczański',
    '1013': u'rawski',
    '1014': u'sieradzki',
    '1015': u'skierniewicki',
    '1016': u'tomaszowski',
    '1017': u'wieluński',
    '1018': u'wieruszowski',
    '1019': u'zduńskowolski',
    '1020': u'zgierski',
    '1021': u'brzeziński',
    '1061': u'Łódź',
    '1062': u'Piotrków Trybunalski',
    '1063': u'Skierniewice',
    '1201': u'bocheński',
    '1202': u'brzeski',
    '1203': u'chrzanowski',
    '1204': u'dąbrowski',
    '1205': u'gorlicki',
    '1206': u'krakowski',
    '1207': u'limanowski',
    '1208': u'miechowski',
    '1209': u'myślenicki',
    '1210': u'nowosądecki',
    '1211': u'nowotarski',
    '1212': u'olkuski',
    '1213': u'oświęcimski',
    '1214': u'proszowicki',
    '1215': u'suski',
    '1216': u'tarnowski',
    '1217': u'tatrzański',
    '1218': u'wadowicki',
    '1219': u'wielicki',
    '1261': u'Kraków',
    '1262': u'Nowy Sącz',
    '1263': u'Tarnów',
    '1401': u'białobrzeski',
    '1402': u'ciechanowski',
    '1403': u'garwoliński',
    '1404': u'gostyniński',
    '1405': u'grodziski',
    '1406': u'grójecki',
    '1407': u'kozienicki',
    '1408': u'legionowski',
    '1409': u'lipski',
    '1410': u'łosicki',
    '1411': u'makowski',
    '1412': u'miński',
    '1413': u'mławski',
    '1414': u'nowodworski',
    '1415': u'ostrołęcki',
    '1416': u'ostrowski',
    '1417': u'otwocki',
    '1418': u'piaseczyński',
    '1419': u'płocki',
    '1420': u'płoński',
    '1421': u'pruszkowski',
    '1422': u'przasnyski',
    '1423': u'przysuski',
    '1424': u'pułtuski',
    '1425': u'radomski',
    '1426': u'siedlecki',
    '1427': u'sierpecki',
    '1428': u'sochaczewski',
    '1429': u'sokołowski',
    '1430': u'szydłowiecki',
    '1432': u'warszawski zachodni',
    '1433': u'węgrowski',
    '1434': u'wołomiński',
    '1435': u'wyszkowski',
    '1436': u'zwoleński',
    '1437': u'żuromiński',
    '1438': u'żyrardowski',
    '1461': u'Ostrołęka',
    '1462': u'Płock',
    '1463': u'Radom',
    '1464': u'Siedlce',
    '1465': u'Warszawa',
    '1601': u'brzeski',
    '1602': u'głubczycki',
    '1603': u'kędzierzyńsko-kozielski',
    '1604': u'kluczborski',
    '1605': u'krapkowicki',
    '1606': u'namysłowski',
    '1607': u'nyski',
    '1608': u'oleski',
    '1609': u'opolski',
    '1610': u'prudnicki',
    '1611': u'strzelecki',
    '1661': u'Opole',
    '1801': u'bieszczadzki',
    '1802': u'brzozowski',
    '1803': u'dębicki',
    '1804': u'jarosławski',
    '1805': u'jasielski',
    '1806': u'kolbuszowski',
    '1807': u'krośnieński',
    '1808': u'leżajski',
    '1809': u'lubaczowski',
    '1810': u'łańcucki',
    '1811': u'mielecki',
    '1812': u'niżański',
    '1813': u'przemyski',
    '1814': u'przeworski',
    '1815': u'ropczycko-sędziszowski',
    '1816': u'rzeszowski',
    '1817': u'sanocki',
    '1818': u'stalowowolski',
    '1819': u'strzyżowski',
    '1820': u'tarnobrzeski',
    '1821': u'leski',
    '1861': u'Krosno',
    '1862': u'Przemyśl',
    '1863': u'Rzeszów',
    '1864': u'Tarnobrzeg',
    '2001': u'augustowski',
    '2002': u'białostocki',
    '2003': u'bielski',
    '2004': u'grajewski',
    '2005': u'hajnowski',
    '2006': u'kolneński',
    '2007': u'łomżyński',
    '2008': u'moniecki',
    '2009': u'sejneński',
    '2010': u'siemiatycki',
    '2011': u'sokólski',
    '2012': u'suwalski',
    '2013': u'wysokomazowiecki',
    '2014': u'zambrowski',
    '2061': u'Białystok',
    '2062': u'Łomża',
    '2063': u'Suwałki',
    '2201': u'bytowski',
    '2202': u'chojnicki',
    '2203': u'człuchowski',
    '2204': u'gdański',
    '2205': u'kartuski',
    '2206': u'kościerski',
    '2207': u'kwidzyński',
    '2208': u'lęborski',
    '2209': u'malborski',
    '2210': u'nowodworski',
    '2211': u'pucki',
    '2212': u'słupski',
    '2213': u'starogardzki',
    '2214': u'tczewski',
    '2215': u'wejherowski',
    '2216': u'sztumski',
    '2261': u'Gdańsk',
    '2262': u'Gdynia',
    '2263': u'Słupsk',
    '2264': u'Sopot',
    '2401': u'będziński',
    '2402': u'bielski',
    '2403': u'cieszyński',
    '2404': u'częstochowski',
    '2405': u'gliwicki',
    '2406': u'kłobucki',
    '2407': u'lubliniecki',
    '2408': u'mikołowski',
    '2409': u'myszkowski',
    '2410': u'pszczyński',
    '2411': u'raciborski',
    '2412': u'rybnicki',
    '2413': u'tarnogórski',
    '2414': u'bieruńsko-lędziński',
    '2415': u'wodzisławski',
    '2416': u'zawierciański',
    '2417': u'żywiecki',
    '2461': u'Bielsko-Biała',
    '2462': u'Bytom',
    '2463': u'Chorzów',
    '2464': u'Częstochowa',
    '2465': u'Dąbrowa Górnicza',
    '2466': u'Gliwice',
    '2467': u'Jastrzębie-Zdrój',
    '2468': u'Jaworzno',
    '2469': u'Katowice',
    '2470': u'Mysłowice',
    '2471': u'Piekary Śląskie',
    '2472': u'Ruda Śląska',
    '2473': u'Rybnik',
    '2474': u'Siemianowice Śląskie',
    '2475': u'Sosnowiec',
    '2476': u'Świętochłowice',
    '2477': u'Tychy',
    '2478': u'Zabrze',
    '2479': u'Żory',
    '2601': u'buski',
    '2602': u'jędrzejowski',
    '2603': u'kazimierski',
    '2604': u'kielecki',
    '2605': u'konecki',
    '2606': u'opatowski',
    '2607': u'ostrowiecki',
    '2608': u'pińczowski',
    '2609': u'sandomierski',
    '2610': u'skarżyski',
    '2611': u'starachowicki',
    '2612': u'staszowski',
    '2613': u'włoszczowski',
    '2661': u'Kielce',
    '2801': u'bartoszycki',
    '2802': u'braniewski',
    '2803': u'działdowski',
    '2804': u'elbląski',
    '2805': u'ełcki',
    '2806': u'giżycki',
    '2807': u'iławski',
    '2808': u'kętrzyński',
    '2809': u'lidzbarski',
    '2810': u'mrągowski',
    '2811': u'nidzicki',
    '2812': u'nowomiejski',
    '2813': u'olecki',
    '2814': u'olsztyński',
    '2815': u'ostródzki',
    '2816': u'piski',
    '2817': u'szczycieński',
    '2818': u'gołdapski',
    '2819': u'węgorzewski',
    '2861': u'Elbląg',
    '2862': u'Olsztyn',
    '3001': u'chodzieski',
    '3002': u'czarnkowsko-trzcianecki',
    '3003': u'gnieźnieński',
    '3004': u'gostyński',
    '3005': u'grodziski',
    '3006': u'jarociński',
    '3007': u'kaliski',
    '3008': u'kępiński',
    '3009': u'kolski',
    '3010': u'koniński',
    '3011': u'kościański',
    '3012': u'krotoszyński',
    '3013': u'leszczyński',
    '3014': u'międzychodzki',
    '3015': u'nowotomyski',
    '3016': u'obornicki',
    '3017': u'ostrowski',
    '3018': u'ostrzeszowski',
    '3019': u'pilski',
    '3020': u'pleszewski',
    '3021': u'poznański',
    '3022': u'rawicki',
    '3023': u'słupecki',
    '3024': u'szamotulski',
    '3025': u'średzki',
    '3026': u'śremski',
    '3027': u'turecki',
    '3028': u'wągrowiecki',
    '3029': u'wolsztyński',
    '3030': u'wrzesiński',
    '3031': u'złotowski',
    '3061': u'Kalisz',
    '3062': u'Konin',
    '3063': u'Leszno',
    '3064': u'Poznań',
    '3201': u'białogardzki',
    '3202': u'choszczeński',
    '3203': u'drawski',
    '3204': u'goleniowski',
    '3205': u'gryficki',
    '3206': u'gryfiński',
    '3207': u'kamieński',
    '3208': u'kołobrzeski',
    '3209': u'koszaliński',
    '3210': u'myśliborski',
    '3211': u'policki',
    '3212': u'pyrzycki',
    '3213': u'sławieński',
    '3214': u'stargardzki',
    '3215': u'szczecinecki',
    '3216': u'świdwiński',
    '3217': u'wałecki',
    '3218': u'łobeski',
    '3261': u'Koszalin',
    '3262': u'Szczecin',
    '3263': u'Świnoujście',
}

PL_COMMUNES = {
    '0201011': u'Bolesławiec',
    '0201022': u'Bolesławiec',
    '0201032': u'Gromadka',
    '0201043': u'Nowogrodziec',
    '0201052': u'Osiecznica',
    '0201062': u'Warta Bolesławiecka',
    '0202011': u'Bielawa',
    '0202021': u'Dzierżoniów',
    '0202031': u'Pieszyce',
    '0202041': u'Piława Górna',
    '0202052': u'Dzierżoniów',
    '0202062': u'Łagiewniki',
    '0202073': u'Niemcza',
    '0203011': u'Głogów',
    '0203022': u'Głogów',
    '0203032': u'Jerzmanowa',
    '0203042': u'Kotla',
    '0203052': u'Pęcław',
    '0203062': u'Żukowice',
    '0204013': u'Góra',
    '0204022': u'Jemielno',
    '0204032': u'Niechlów',
    '0204043': u'Wąsosz',
    '0205011': u'Jawor',
    '0205023': u'Bolków',
    '0205032': u'Męcinka',
    '0205042': u'Mściwojów',
    '0205052': u'Paszowice',
    '0205062': u'Wądroże Wielkie',
    '0206011': u'Karpacz',
    '0206021': u'Kowary',
    '0206031': u'Piechowice',
    '0206041': u'Szklarska Poręba',
    '0206052': u'Janowice Wielkie',
    '0206062': u'Jeżów Sudecki',
    '0206072': u'Mysłakowice',
    '0206082': u'Podgórzyn',
    '0206092': u'Stara Kamienica',
    '0207011': u'Kamienna Góra',
    '0207022': u'Kamienna Góra',
    '0207033': u'Lubawka',
    '0207042': u'Marciszów',
    '0208011': u'Duszniki-Zdrój',
    '0208021': u'Kłodzko',
    '0208031': u'Kudowa-Zdrój',
    '0208041': u'Nowa Ruda',
    '0208051': u'Polanica-Zdrój',
    '0208063': u'Bystrzyca Kłodzka',
    '0208072': u'Kłodzko',
    '0208083': u'Lądek-Zdrój',
    '0208092': u'Lewin Kłodzki',
    '0208103': u'Międzylesie',
    '0208112': u'Nowa Ruda',
    '0208123': u'Radków',
    '0208133': u'Stronie Śląskie',
    '0208143': u'Szczytna',
    '0209011': u'Chojnów',
    '0209022': u'Chojnów',
    '0209032': u'Krotoszyce',
    '0209042': u'Kunice',
    '0209052': u'Legnickie Pole',
    '0209062': u'Miłkowice',
    '0209073': u'Prochowice',
    '0209082': u'Ruja',
    '0210011': u'Lubań',
    '0210021': u'Świeradów-Zdrój',
    '0210033': u'Leśna',
    '0210042': u'Lubań',
    '0210052': u'Olszyna',
    '0210062': u'Platerówka',
    '0210072': u'Siekierczyn',
    '0211011': u'Lubin',
    '0211022': u'Lubin',
    '0211032': u'Rudna',
    '0211043': u'Ścinawa',
    '0212013': u'Gryfów Śląski',
    '0212023': u'Lubomierz',
    '0212033': u'Lwówek Śląski',
    '0212043': u'Mirsk',
    '0212053': u'Wleń',
    '0213012': u'Cieszków',
    '0213022': u'Krośnice',
    '0213033': u'Milicz',
    '0214011': u'Oleśnica',
    '0214023': u'Bierutów',
    '0214032': u'Dobroszyce',
    '0214042': u'Dziadowa Kłoda',
    '0214053': u'Międzybórz',
    '0214062': u'Oleśnica',
    '0214073': u'Syców',
    '0214083': u'Twardogóra',
    '0215011': u'Oława',
    '0215022': u'Domaniów',
    '0215033': u'Jelcz-Laskowice',
    '0215042': u'Oława',
    '0216013': u'Chocianów',
    '0216022': u'Gaworzyce',
    '0216032': u'Grębocice',
    '0216043': u'Polkowice',
    '0216053': u'Przemków',
    '0216062': u'Radwanice',
    '0217012': u'Borów',
    '0217022': u'Kondratowice',
    '0217032': u'Przeworno',
    '0217043': u'Strzelin',
    '0217053': u'Wiązów',
    '0218012': u'Kostomłoty',
    '0218022': u'Malczyce',
    '0218032': u'Miękinia',
    '0218043': u'Środa Śląska',
    '0218052': u'Udanin',
    '0219011': u'Świdnica',
    '0219021': u'Świebodzice',
    '0219032': u'Dobromierz',
    '0219043': u'Jaworzyna Śląska',
    '0219052': u'Marcinowice',
    '0219063': u'Strzegom',
    '0219072': u'Świdnica',
    '0219083': u'Żarów',
    '0220013': u'Oborniki Śląskie',
    '0220023': u'Prusice',
    '0220033': u'Trzebnica',
    '0220042': u'Wisznia Mała',
    '0220052': u'Zawonia',
    '0220063': u'Żmigród',
    '0221011': u'Boguszów-Gorce',
    '0221021': u'Jedlina-Zdrój',
    '0221031': u'Szczawno-Zdrój',
    '0221042': u'Czarny Bór',
    '0221053': u'Głuszyca',
    '0221063': u'Mieroszów',
    '0221072': u'Stare Bogaczowice',
    '0221082': u'Walim',
    '0221091': u'Wałbrzych',
    '0222013': u'Brzeg Dolny',
    '0222022': u'Wińsko',
    '0222033': u'Wołów',
    '0223012': u'Czernica',
    '0223022': u'Długołęka',
    '0223032': u'Jordanów Śląski',
    '0223043': u'Kąty Wrocławskie',
    '0223052': u'Kobierzyce',
    '0223062': u'Mietków',
    '0223073': u'Sobótka',
    '0223083': u'Święta Katarzyna',
    '0223092': u'Żórawina',
    '0224013': u'Bardo',
    '0224022': u'Ciepłowody',
    '0224032': u'Kamieniec Ząbkowicki',
    '0224042': u'Stoszowice',
    '0224053': u'Ząbkowice Śląskie',
    '0224063': u'Ziębice',
    '0224073': u'Złoty Stok',
    '0225011': u'Zawidów',
    '0225021': u'Zgorzelec',
    '0225033': u'Bogatynia',
    '0225043': u'Pieńsk',
    '0225052': u'Sulików',
    '0225063': u'Węgliniec',
    '0225072': u'Zgorzelec',
    '0226011': u'Wojcieszów',
    '0226021': u'Złotoryja',
    '0226032': u'Pielgrzymka',
    '0226043': u'Świerzawa',
    '0226052': u'Zagrodno',
    '0226062': u'Złotoryja',
    '0261011': u'Jelenia Góra',
    '0262011': u'Legnica',
    '0264011': u'Wrocław',
    '0264029': u'Wrocław-Fabryczna',
    '0264039': u'Wrocław-Krzyki',
    '0264049': u'Wrocław-Psie Pole',
    '0264059': u'Wrocław-Stare Miasto',
    '0264069': u'Wrocław-Śródmieście',
    '0401011': u'Aleksandrów Kujawski',
    '0401021': u'Ciechocinek',
    '0401031': u'Nieszawa',
    '0401042': u'Aleksandrów Kujawski',
    '0401052': u'Bądkowo',
    '0401062': u'Koneck',
    '0401072': u'Raciążek',
    '0401082': u'Waganiec',
    '0401092': u'Zakrzewo',
    '0402011': u'Brodnica',
    '0402022': u'Bobrowo',
    '0402032': u'Brodnica',
    '0402042': u'Brzozie',
    '0402053': u'Górzno',
    '0402062': u'Grążawy',
    '0402073': u'Jabłonowo Pomorskie',
    '0402082': u'Osiek',
    '0402092': u'Świedziebnia',
    '0402102': u'Zbiczno',
    '0403012': u'Białe Błota',
    '0403022': u'Dąbrowa Chełmińska',
    '0403032': u'Dobrcz',
    '0403043': u'Koronowo',
    '0403052': u'Nowa Wieś Wielka',
    '0403062': u'Osielsko',
    '0403072': u'Sicienko',
    '0403083': u'Solec Kujawski',
    '0404011': u'Chełmno',
    '0404022': u'Chełmno',
    '0404032': u'Kijewo Królewskie',
    '0404042': u'Lisewo',
    '0404052': u'Papowo Biskupie',
    '0404062': u'Stolno',
    '0404072': u'Unisław',
    '0405011': u'Golub-Dobrzyń',
    '0405022': u'Ciechocin',
    '0405032': u'Golub-Dobrzyń',
    '0405043': u'Kowalewo Pomorskie',
    '0405052': u'Radomin',
    '0405062': u'Zbójno',
    '0406012': u'Grudziądz',
    '0406022': u'Gruta',
    '0406033': u'Łasin',
    '0406043': u'Radzyń Chełmiński',
    '0406052': u'Rogóźno',
    '0406062': u'Świecie nad Osą',
    '0407011': u'Inowrocław',
    '0407022': u'Dąbrowa Biskupia',
    '0407033': u'Gniewkowo',
    '0407042': u'Inowrocław',
    '0407053': u'Janikowo',
    '0407063': u'Kruszwica',
    '0407073': u'Pakość',
    '0407082': u'Rojewo',
    '0407092': u'Złotniki Kujawskie',
    '0408011': u'Lipno',
    '0408022': u'Bobrowniki',
    '0408032': u'Chrostkowo',
    '0408043': u'Dobrzyń nad Wisłą',
    '0408052': u'Kikół',
    '0408062': u'Lipno',
    '0408073': u'Skępe',
    '0408082': u'Tłuchowo',
    '0408092': u'Wielgie',
    '0409012': u'Dąbrowa',
    '0409022': u'Jeziora Wielkie',
    '0409033': u'Mogilno',
    '0409043': u'Strzelno',
    '0410013': u'Kcynia',
    '0410023': u'Mrocza',
    '0410033': u'Nakło nad Notecią',
    '0410042': u'Sadki',
    '0410053': u'Szubin',
    '0411011': u'Radziejów',
    '0411022': u'Bytoń',
    '0411032': u'Dobre',
    '0411042': u'Osięciny',
    '0411053': u'Piotrków Kujawski',
    '0411062': u'Radziejów',
    '0411072': u'Topólka',
    '0412011': u'Rypin',
    '0412022': u'Brzuze',
    '0412032': u'Rogowo',
    '0412042': u'Rypin',
    '0412052': u'Skrwilno',
    '0412062': u'Wąpielsk',
    '0413013': u'Kamień Krajeński',
    '0413023': u'Sępólno Krajeńskie',
    '0413032': u'Sośno',
    '0413043': u'Więcbork',
    '0414012': u'Bukowiec',
    '0414022': u'Dragacz',
    '0414032': u'Drzycim',
    '0414042': u'Jeżewo',
    '0414052': u'Lniano',
    '0414063': u'Nowe',
    '0414072': u'Osie',
    '0414082': u'Pruszcz',
    '0414093': u'Świecie',
    '0414102': u'Świekatowo',
    '0414112': u'Warlubie',
    '0415011': u'Chełmża',
    '0415022': u'Chełmża',
    '0415032': u'Czernikowo',
    '0415042': u'Lubicz',
    '0415052': u'Łubianka',
    '0415062': u'Łysomice',
    '0415072': u'Obrowo',
    '0415082': u'Wielka Nieszawka',
    '0415092': u'Zławieś Wielka',
    '0416012': u'Cekcyn',
    '0416022': u'Gostycyn',
    '0416032': u'Kęsowo',
    '0416042': u'Lubiewo',
    '0416052': u'Śliwice',
    '0416063': u'Tuchola',
    '0417011': u'Wąbrzeźno',
    '0417022': u'Dębowa Łąka',
    '0417032': u'Książki',
    '0417042': u'Płużnica',
    '0417052': u'Wąbrzeźno',
    '0418011': u'Kowal',
    '0418022': u'Baruchowo',
    '0418032': u'Boniewo',
    '0418043': u'Brześć Kujawski',
    '0418052': u'Choceń',
    '0418063': u'Chodecz',
    '0418072': u'Fabianki',
    '0418083': u'Izbica Kujawska',
    '0418092': u'Kowal',
    '0418102': u'Lubanie',
    '0418113': u'Lubień Kujawski',
    '0418123': u'Lubraniec',
    '0418132': u'Włocławek',
    '0419013': u'Barcin',
    '0419022': u'Gąsawa',
    '0419033': u'Janowiec Wielkopolski',
    '0419043': u'Łabiszyn',
    '0419052': u'Rogowo',
    '0419063': u'Żnin',
    '0461011': u'Bydgoszcz',
    '0462011': u'Grudziądz',
    '0463011': u'Toruń',
    '0464011': u'Włocławek',
    '0601011': u'Międzyrzec Podlaski',
    '0601021': u'Terespol',
    '0601032': u'Biała Podlaska',
    '0601042': u'Drelów',
    '0601052': u'Janów Podlaski',
    '0601062': u'Kodeń',
    '0601072': u'Konstantynów',
    '0601082': u'Leśna Podlaska',
    '0601092': u'Łomazy',
    '0601102': u'Międzyrzec Podlaski',
    '0601112': u'Piszczac',
    '0601122': u'Rokitno',
    '0601132': u'Rossosz',
    '0601142': u'Sławatycze',
    '0601152': u'Sosnówka',
    '0601162': u'Terespol',
    '0601172': u'Tuczna',
    '0601182': u'Wisznice',
    '0601192': u'Zalesie',
    '0602011': u'Biłgoraj',
    '0602022': u'Aleksandrów',
    '0602032': u'Biłgoraj',
    '0602042': u'Biszcza',
    '0602053': u'Frampol',
    '0602062': u'Goraj',
    '0602073': u'Józefów',
    '0602082': u'Księżpol',
    '0602092': u'Łukowa',
    '0602102': u'Obsza',
    '0602112': u'Potok Górny',
    '0602123': u'Tarnogród',
    '0602132': u'Tereszpol',
    '0602142': u'Turobin',
    '0603011': u'Rejowiec Fabryczny',
    '0603022': u'Białopole',
    '0603032': u'Chełm',
    '0603042': u'Dorohusk',
    '0603052': u'Dubienka',
    '0603062': u'Kamień',
    '0603072': u'Leśniowice',
    '0603082': u'Rejowiec Fabryczny',
    '0603092': u'Ruda-Huta',
    '0603102': u'Sawin',
    '0603112': u'Siedliszcze',
    '0603122': u'Wierzbica',
    '0603132': u'Wojsławice',
    '0603142': u'Żmudź',
    '0604011': u'Hrubieszów',
    '0604022': u'Dołhobyczów',
    '0604032': u'Horodło',
    '0604042': u'Hrubieszów',
    '0604052': u'Mircze',
    '0604062': u'Trzeszczany',
    '0604072': u'Uchanie',
    '0604082': u'Werbkowice',
    '0605012': u'Batorz',
    '0605022': u'Chrzanów',
    '0605032': u'Dzwola',
    '0605042': u'Godziszów',
    '0605053': u'Janów Lubelski',
    '0605062': u'Modliborzyce',
    '0605072': u'Potok Wielki',
    '0606011': u'Krasnystaw',
    '0606022': u'Fajsławice',
    '0606032': u'Gorzków',
    '0606042': u'Izbica',
    '0606052': u'Krasnystaw',
    '0606062': u'Kraśniczyn',
    '0606072': u'Łopiennik Górny',
    '0606082': u'Rejowiec',
    '0606092': u'Rudnik',
    '0606102': u'Siennica Różana',
    '0606112': u'Żółkiewka',
    '0607011': u'Kraśnik',
    '0607023': u'Annopol',
    '0607032': u'Dzierzkowice',
    '0607042': u'Gościeradów',
    '0607052': u'Kraśnik',
    '0607062': u'Szastarka',
    '0607072': u'Trzydnik Duży',
    '0607082': u'Urzędów',
    '0607092': u'Wilkołaz',
    '0607102': u'Zakrzówek',
    '0608011': u'Lubartów',
    '0608022': u'Abramów',
    '0608032': u'Firlej',
    '0608042': u'Jeziorzany',
    '0608052': u'Kamionka',
    '0608063': u'Kock',
    '0608072': u'Lubartów',
    '0608082': u'Michów',
    '0608092': u'Niedźwiada',
    '0608103': u'Ostrów Lubelski',
    '0608112': u'Ostrówek',
    '0608122': u'Serniki',
    '0608132': u'Uścimów',
    '0609013': u'Bełżyce',
    '0609022': u'Borzechów',
    '0609033': u'Bychawa',
    '0609042': u'Garbów',
    '0609052': u'Głusk',
    '0609062': u'Jabłonna',
    '0609072': u'Jastków',
    '0609082': u'Konopnica',
    '0609092': u'Krzczonów',
    '0609102': u'Niedrzwica Duża',
    '0609112': u'Niemce',
    '0609122': u'Strzyżewice',
    '0609132': u'Wojciechów',
    '0609142': u'Wólka',
    '0609152': u'Wysokie',
    '0609162': u'Zakrzew',
    '0610012': u'Cyców',
    '0610022': u'Ludwin',
    '0610033': u'Łęczna',
    '0610042': u'Milejów',
    '0610052': u'Puchaczów',
    '0610062': u'Spiczyn',
    '0611011': u'Łuków',
    '0611021': u'Stoczek Łukowski',
    '0611032': u'Adamów',
    '0611042': u'Krzywda',
    '0611052': u'Łuków',
    '0611062': u'Serokomla',
    '0611072': u'Stanin',
    '0611082': u'Stoczek Łukowski',
    '0611092': u'Trzebieszów',
    '0611102': u'Wojcieszków',
    '0611112': u'Wola Mysłowska',
    '0612012': u'Chodel',
    '0612022': u'Józefów nad Wisłą',
    '0612032': u'Karczmiska',
    '0612042': u'Łaziska',
    '0612053': u'Opole Lubelskie',
    '0612063': u'Poniatowa',
    '0612072': u'Wilków',
    '0613012': u'Dębowa Kłoda',
    '0613022': u'Jabłoń',
    '0613032': u'Milanów',
    '0613043': u'Parczew',
    '0613052': u'Podedwórze',
    '0613062': u'Siemień',
    '0613072': u'Sosnowica',
    '0614011': u'Puławy',
    '0614022': u'Baranów',
    '0614032': u'Janowiec',
    '0614043': u'Kazimierz Dolny',
    '0614052': u'Końskowola',
    '0614062': u'Kurów',
    '0614072': u'Markuszów',
    '0614083': u'Nałęczów',
    '0614092': u'Puławy',
    '0614102': u'Wąwolnica',
    '0614112': u'Żyrzyn',
    '0615011': u'Radzyń Podlaski',
    '0615022': u'Borki',
    '0615032': u'Czemierniki',
    '0615042': u'Kąkolewnica Wschodnia',
    '0615052': u'Komarówka Podlaska',
    '0615062': u'Radzyń Podlaski',
    '0615072': u'Ulan-Majorat',
    '0615082': u'Wohyń',
    '0616011': u'Dęblin',
    '0616022': u'Kłoczew',
    '0616032': u'Nowodwór',
    '0616043': u'Ryki',
    '0616052': u'Stężyca',
    '0616062': u'Ułęż',
    '0617011': u'Świdnik',
    '0617022': u'Mełgiew',
    '0617033': u'Piaski',
    '0617042': u'Rybczewice',
    '0617052': u'Trawniki',
    '0618011': u'Tomaszów Lubelski',
    '0618022': u'Bełżec',
    '0618032': u'Jarczów',
    '0618042': u'Krynice',
    '0618052': u'Lubycza Królewska',
    '0618062': u'Łaszczów',
    '0618072': u'Rachanie',
    '0618082': u'Susiec',
    '0618092': u'Tarnawatka',
    '0618102': u'Telatyn',
    '0618112': u'Tomaszów Lubelski',
    '0618123': u'Tyszowce',
    '0618132': u'Ulhówek',
    '0619011': u'Włodawa',
    '0619022': u'Hanna',
    '0619032': u'Hańsk',
    '0619042': u'Stary Brus',
    '0619052': u'Urszulin',
    '0619062': u'Włodawa',
    '0619072': u'Wola Uhruska',
    '0619082': u'Wyryki',
    '0620012': u'Adamów',
    '0620022': u'Grabowiec',
    '0620032': u'Komarów-Osada',
    '0620043': u'Krasnobród',
    '0620052': u'Łabunie',
    '0620062': u'Miączyn',
    '0620072': u'Nielisz',
    '0620082': u'Radecznica',
    '0620092': u'Sitno',
    '0620102': u'Skierbieszów',
    '0620112': u'Stary Zamość',
    '0620122': u'Sułów',
    '0620133': u'Szczebrzeszyn',
    '0620142': u'Zamość',
    '0620153': u'Zwierzyniec',
    '0661011': u'Biała Podlaska',
    '0662011': u'Chełm',
    '0663011': u'Lublin',
    '0664011': u'Zamość',
    '0801011': u'Kostrzyn nad Odrą',
    '0801022': u'Bogdaniec',
    '0801032': u'Deszczno',
    '0801042': u'Kłodawa',
    '0801052': u'Lubiszyn',
    '0801062': u'Santok',
    '0801073': u'Witnica',
    '0802011': u'Gubin',
    '0802022': u'Bobrowice',
    '0802032': u'Bytnica',
    '0802042': u'Dąbie',
    '0802052': u'Gubin',
    '0802063': u'Krosno Odrzańskie',
    '0802072': u'Maszewo',
    '0803012': u'Bledzew',
    '0803023': u'Międzyrzecz',
    '0803032': u'Przytoczna',
    '0803042': u'Pszczew',
    '0803053': u'Skwierzyna',
    '0803063': u'Trzciel',
    '0804011': u'Nowa Sól',
    '0804023': u'Bytom Odrzański',
    '0804032': u'Kolsko',
    '0804043': u'Kożuchów',
    '0804052': u'Nowa Sól',
    '0804063': u'Nowe Miasteczko',
    '0804072': u'Otyń',
    '0804082': u'Siedlisko',
    '0805013': u'Cybinka',
    '0805022': u'Górzyca',
    '0805033': u'Ośno Lubuskie',
    '0805043': u'Rzepin',
    '0805053': u'Słubice',
    '0806013': u'Dobiegniew',
    '0806023': u'Drezdenko',
    '0806032': u'Stare Kurowo',
    '0806043': u'Strzelce Krajeńskie',
    '0806052': u'Zwierzyn',
    '0807012': u'Krzeszyce',
    '0807023': u'Lubniewice',
    '0807032': u'Słońsk',
    '0807043': u'Sulęcin',
    '0807053': u'Torzym',
    '0808012': u'Lubrza',
    '0808022': u'Łagów',
    '0808032': u'Skąpe',
    '0808042': u'Szczaniec',
    '0808053': u'Świebodzin',
    '0808063': u'Zbąszynek',
    '0809013': u'Babimost',
    '0809022': u'Bojadła',
    '0809033': u'Czerwieńsk',
    '0809043': u'Kargowa',
    '0809053': u'Nowogród Bobrzański',
    '0809063': u'Sulechów',
    '0809072': u'Świdnica',
    '0809082': u'Trzebiechów',
    '0809092': u'Zabór',
    '0809102': u'Zielona Góra',
    '0810011': u'Gozdnica',
    '0810021': u'Żagań',
    '0810032': u'Brzeźnica',
    '0810043': u'Iłowa',
    '0810053': u'Małomice',
    '0810062': u'Niegosławice',
    '0810073': u'Szprotawa',
    '0810082': u'Wymiarki',
    '0810092': u'Żagań',
    '0811011': u'Łęknica',
    '0811021': u'Żary',
    '0811032': u'Brody',
    '0811043': u'Jasień',
    '0811052': u'Lipinki Łużyckie',
    '0811063': u'Lubsko',
    '0811072': u'Przewóz',
    '0811082': u'Trzebiel',
    '0811092': u'Tuplice',
    '0811102': u'Żary',
    '0812013': u'Sława',
    '0812023': u'Szlichtyngowa',
    '0812033': u'Wschowa',
    '0861011': u'Gorzów Wielkopolski',
    '0862011': u'Zielona Góra',
    '1001011': u'Bełchatów',
    '1001022': u'Bełchatów',
    '1001032': u'Drużbice',
    '1001042': u'Kleszczów',
    '1001052': u'Kluki',
    '1001062': u'Rusiec',
    '1001072': u'Szczerców',
    '1001083': u'Zelów',
    '1002011': u'Kutno',
    '1002022': u'Bedlno',
    '1002032': u'Dąbrowice',
    '1002043': u'Krośniewice',
    '1002052': u'Krzyżanów',
    '1002062': u'Kutno',
    '1002072': u'Łanięta',
    '1002082': u'Nowe Ostrowy',
    '1002092': u'Oporów',
    '1002102': u'Strzelce',
    '1002113': u'Żychlin',
    '1003012': u'Buczek',
    '1003023': u'Łask',
    '1003032': u'Sędziejowice',
    '1003042': u'Widawa',
    '1003052': u'Wodzierady',
    '1004011': u'Łęczyca',
    '1004022': u'Daszyna',
    '1004032': u'Góra Świętej Małgorzaty',
    '1004042': u'Grabów',
    '1004052': u'Łęczyca',
    '1004062': u'Piątek',
    '1004072': u'Świnice Warckie',
    '1004082': u'Witonia',
    '1005011': u'Łowicz',
    '1005022': u'Bielawy',
    '1005032': u'Chąśno',
    '1005042': u'Domaniewice',
    '1005052': u'Kiernozia',
    '1005062': u'Kocierzew Południowy',
    '1005072': u'Łowicz',
    '1005082': u'Łyszkowice',
    '1005092': u'Nieborów',
    '1005102': u'Zduny',
    '1006022': u'Andrespol',
    '1006032': u'Brójce',
    '1006073': u'Koluszki',
    '1006082': u'Nowosolna',
    '1006102': u'Rzgów',
    '1006113': u'Tuszyn',
    '1007012': u'Białaczów',
    '1007023': u'Drzewica',
    '1007032': u'Mniszków',
    '1007043': u'Opoczno',
    '1007052': u'Paradyż',
    '1007062': u'Poświętne',
    '1007072': u'Sławno',
    '1007082': u'Żarnów',
    '1008011': u'Konstantynów Łódzki',
    '1008021': u'Pabianice',
    '1008032': u'Dłutów',
    '1008042': u'Dobroń',
    '1008052': u'Ksawerów',
    '1008062': u'Lutomiersk',
    '1008072': u'Pabianice',
    '1009013': u'Działoszyn',
    '1009022': u'Kiełczygłów',
    '1009032': u'Nowa Brzeźnica',
    '1009043': u'Pajęczno',
    '1009052': u'Rząśnia',
    '1009062': u'Siemkowice',
    '1009072': u'Strzelce Wielkie',
    '1009082': u'Sulmierzyce',
    '1010012': u'Aleksandrów',
    '1010022': u'Czarnocin',
    '1010032': u'Gorzkowice',
    '1010042': u'Grabica',
    '1010052': u'Łęki Szlacheckie',
    '1010062': u'Moszczenica',
    '1010072': u'Ręczno',
    '1010082': u'Rozprza',
    '1010093': u'Sulejów',
    '1010102': u'Wola Krzysztoporska',
    '1010112': u'Wolbórz',
    '1011012': u'Dalików',
    '1011022': u'Pęczniew',
    '1011033': u'Poddębice',
    '1011043': u'Uniejów',
    '1011052': u'Wartkowice',
    '1011062': u'Zadzim',
    '1012011': u'Radomsko',
    '1012022': u'Dobryszyce',
    '1012032': u'Gidle',
    '1012042': u'Gomunice',
    '1012053': u'Kamieńsk',
    '1012062': u'Kobiele Wielkie',
    '1012072': u'Kodrąb',
    '1012082': u'Lgota Wielka',
    '1012092': u'Ładzice',
    '1012102': u'Masłowice',
    '1012113': u'Przedbórz',
    '1012122': u'Radomsko',
    '1012132': u'Wielgomłyny',
    '1012142': u'Żytno',
    '1013011': u'Rawa Mazowiecka',
    '1013023': u'Biała Rawska',
    '1013032': u'Cielądz',
    '1013042': u'Rawa Mazowiecka',
    '1013052': u'Regnów',
    '1013062': u'Sadkowice',
    '1014011': u'Sieradz',
    '1014023': u'Błaszki',
    '1014032': u'Brąszewice',
    '1014042': u'Brzeźnio',
    '1014052': u'Burzenin',
    '1014062': u'Goszczanów',
    '1014072': u'Klonowa',
    '1014082': u'Sieradz',
    '1014093': u'Warta',
    '1014102': u'Wróblew',
    '1014113': u'Złoczew',
    '1015012': u'Bolimów',
    '1015022': u'Głuchów',
    '1015032': u'Godzianów',
    '1015042': u'Kowiesy',
    '1015052': u'Lipce Reymontowskie',
    '1015062': u'Maków',
    '1015072': u'Nowy Kawęczyn',
    '1015082': u'Skierniewice',
    '1015092': u'Słupia',
    '1016011': u'Tomaszów Mazowiecki',
    '1016022': u'Będków',
    '1016032': u'Budziszewice',
    '1016042': u'Czerniewice',
    '1016052': u'Inowłódz',
    '1016062': u'Lubochnia',
    '1016072': u'Rokiciny',
    '1016082': u'Rzeczyca',
    '1016092': u'Tomaszów Mazowiecki',
    '1016102': u'Ujazd',
    '1016112': u'Żelechlinek',
    '1017012': u'Biała',
    '1017022': u'Czarnożyły',
    '1017032': u'Konopnica',
    '1017042': u'Mokrsko',
    '1017052': u'Osjaków',
    '1017062': u'Ostrówek',
    '1017072': u'Pątnów',
    '1017082': u'Skomlin',
    '1017093': u'Wieluń',
    '1017102': u'Wierzchlas',
    '1018012': u'Bolesławiec',
    '1018022': u'Czastary',
    '1018032': u'Galewice',
    '1018042': u'Lututów',
    '1018052': u'Łubnice',
    '1018062': u'Sokolniki',
    '1018073': u'Wieruszów',
    '1019011': u'Zduńska Wola',
    '1019023': u'Szadek',
    '1019032': u'Zapolice',
    '1019042': u'Zduńska Wola',
    '1020011': u'Głowno',
    '1020021': u'Ozorków',
    '1020031': u'Zgierz',
    '1020043': u'Aleksandrów Łódzki',
    '1020052': u'Głowno',
    '1020062': u'Ozorków',
    '1020072': u'Parzęczew',
    '1020083': u'Stryków',
    '1020092': u'Zgierz',
    '1021011': u'Brzeziny',
    '1021022': u'Brzeziny',
    '1021032': u'Dmosin',
    '1021042': u'Jeżów',
    '1021052': u'Rogów',
    '1061011': u'Łódź',
    '1061029': u'Łódź-Bałuty',
    '1061039': u'Łódź-Górna',
    '1061049': u'Łódź-Polesie',
    '1061059': u'Łódź-Śródmieście',
    '1061069': u'Łódź-Widzew',
    '1062011': u'Piotrków Trybunalski',
    '1063011': u'Skierniewice',
    '1201011': u'Bochnia',
    '1201022': u'Bochnia',
    '1201032': u'Drwinia',
    '1201042': u'Lipnica Murowana',
    '1201052': u'Łapanów',
    '1201063': u'Nowy Wiśnicz',
    '1201072': u'Rzezawa',
    '1201082': u'Trzciana',
    '1201092': u'Żegocina',
    '1202012': u'Borzęcin',
    '1202023': u'Brzesko',
    '1202033': u'Czchów',
    '1202042': u'Dębno',
    '1202052': u'Gnojnik',
    '1202062': u'Iwkowa',
    '1202072': u'Szczurowa',
    '1203013': u'Alwernia',
    '1203022': u'Babice',
    '1203033': u'Chrzanów',
    '1203043': u'Libiąż',
    '1203053': u'Trzebinia',
    '1204012': u'Bolesław',
    '1204023': u'Dąbrowa Tarnowska',
    '1204032': u'Gręboszów',
    '1204042': u'Mędrzechów',
    '1204052': u'Olesno',
    '1204062': u'Radgoszcz',
    '1204072': u'Szczucin',
    '1205011': u'Gorlice',
    '1205023': u'Biecz',
    '1205032': u'Bobowa',
    '1205042': u'Gorlice',
    '1205052': u'Lipinki',
    '1205062': u'Łużna',
    '1205072': u'Moszczenica',
    '1205082': u'Ropa',
    '1205092': u'Sękowa',
    '1205102': u'Uście Gorlickie',
    '1206012': u'Czernichów',
    '1206022': u'Igołomia-Wawrzeńczyce',
    '1206032': u'Iwanowice',
    '1206042': u'Jerzmanowice-Przeginia',
    '1206052': u'Kocmyrzów-Luborzyca',
    '1206063': u'Krzeszowice',
    '1206072': u'Liszki',
    '1206082': u'Michałowice',
    '1206092': u'Mogilany',
    '1206103': u'Skała',
    '1206113': u'Skawina',
    '1206123': u'Słomniki',
    '1206132': u'Sułoszowa',
    '1206143': u'Świątniki Górne',
    '1206152': u'Wielka Wieś',
    '1206162': u'Zabierzów',
    '1206172': u'Zielonki',
    '1207011': u'Limanowa',
    '1207021': u'Mszana Dolna',
    '1207032': u'Dobra',
    '1207042': u'Jodłownik',
    '1207052': u'Kamienica',
    '1207062': u'Laskowa',
    '1207072': u'Limanowa',
    '1207082': u'Łukowica',
    '1207092': u'Mszana Dolna',
    '1207102': u'Niedźwiedź',
    '1207112': u'Słopnice',
    '1207122': u'Tymbark',
    '1208012': u'Charsznica',
    '1208022': u'Gołcza',
    '1208032': u'Kozłów',
    '1208042': u'Książ Wielki',
    '1208053': u'Miechów',
    '1208062': u'Racławice',
    '1208072': u'Słaboszów',
    '1209013': u'Dobczyce',
    '1209022': u'Lubień',
    '1209033': u'Myślenice',
    '1209042': u'Pcim',
    '1209052': u'Raciechowice',
    '1209062': u'Siepraw',
    '1209073': u'Sułkowice',
    '1209082': u'Tokarnia',
    '1209092': u'Wiśniowa',
    '1210011': u'Grybów',
    '1210022': u'Chełmiec',
    '1210032': u'Gródek nad Dunajcem',
    '1210042': u'Grybów',
    '1210052': u'Kamionka Wielka',
    '1210062': u'Korzenna',
    '1210073': u'Krynica-Zdrój',
    '1210082': u'Łabowa',
    '1210092': u'Łącko',
    '1210102': u'Łososina Dolna',
    '1210113': u'Muszyna',
    '1210122': u'Nawojowa',
    '1210133': u'Piwniczna-Zdrój',
    '1210142': u'Podegrodzie',
    '1210152': u'Rytro',
    '1210163': u'Stary Sącz',
    '1211011': u'Nowy Targ',
    '1211023': u'Szczawnica',
    '1211032': u'Czarny Dunajec',
    '1211042': u'Czorsztyn',
    '1211052': u'Jabłonka',
    '1211062': u'Krościenko nad Dunajcem',
    '1211072': u'Lipnica Wielka',
    '1211082': u'Łapsze Niżne',
    '1211092': u'Nowy Targ',
    '1211102': u'Ochotnica Dolna',
    '1211112': u'Raba Wyżna',
    '1211123': u'Rabka-Zdrój',
    '1211132': u'Spytkowice',
    '1211142': u'Szaflary',
    '1212011': u'Bukowno',
    '1212032': u'Bolesław',
    '1212042': u'Klucze',
    '1212053': u'Olkusz',
    '1212062': u'Trzyciąż',
    '1212073': u'Wolbrom',
    '1213011': u'Oświęcim',
    '1213023': u'Brzeszcze',
    '1213033': u'Chełmek',
    '1213043': u'Kęty',
    '1213052': u'Osiek',
    '1213062': u'Oświęcim',
    '1213072': u'Polanka Wielka',
    '1213082': u'Przeciszów',
    '1213093': u'Zator',
    '1214012': u'Koniusza',
    '1214022': u'Koszyce',
    '1214032': u'Nowe Brzesko',
    '1214042': u'Pałecznica',
    '1214053': u'Proszowice',
    '1214062': u'Radziemice',
    '1215011': u'Jordanów',
    '1215021': u'Sucha Beskidzka',
    '1215032': u'Budzów',
    '1215042': u'Bystra-Sidzina',
    '1215052': u'Jordanów',
    '1215063': u'Maków Podhalański',
    '1215072': u'Stryszawa',
    '1215082': u'Zawoja',
    '1215092': u'Zembrzyce',
    '1216013': u'Ciężkowice',
    '1216022': u'Gromnik',
    '1216032': u'Lisia Góra',
    '1216042': u'Pleśna',
    '1216052': u'Radłów',
    '1216063': u'Ryglice',
    '1216072': u'Rzepiennik Strzyżewski',
    '1216082': u'Skrzyszów',
    '1216092': u'Tarnów',
    '1216103': u'Tuchów',
    '1216112': u'Wierzchosławice',
    '1216122': u'Wietrzychowice',
    '1216133': u'Wojnicz',
    '1216142': u'Zakliczyn',
    '1216153': u'Żabno',
    '1216162': u'Szerzyny',
    '1217011': u'Zakopane',
    '1217022': u'Biały Dunajec',
    '1217032': u'Bukowina Tatrzańska',
    '1217042': u'Kościelisko',
    '1217052': u'Poronin',
    '1218013': u'Andrychów',
    '1218022': u'Brzeźnica',
    '1218033': u'Kalwaria Zebrzydowska',
    '1218042': u'Lanckorona',
    '1218052': u'Mucharz',
    '1218062': u'Spytkowice',
    '1218072': u'Stryszów',
    '1218082': u'Tomice',
    '1218093': u'Wadowice',
    '1218102': u'Wieprz',
    '1219012': u'Biskupice',
    '1219022': u'Gdów',
    '1219032': u'Kłaj',
    '1219043': u'Niepołomice',
    '1219053': u'Wieliczka',
    '1261011': u'Kraków',
    '1261029': u'Kraków-Krowodrza',
    '1261039': u'Kraków-Nowa Huta',
    '1261049': u'Kraków-Podgórze',
    '1261059': u'Kraków-Śródmieście',
    '1262011': u'Nowy Sącz',
    '1263011': u'Tarnów',
    '1401013': u'Białobrzegi',
    '1401022': u'Promna',
    '1401032': u'Radzanów',
    '1401042': u'Stara Błotnica',
    '1401052': u'Stromiec',
    '1401063': u'Wyśmierzyce',
    '1402011': u'Ciechanów',
    '1402022': u'Ciechanów',
    '1402033': u'Glinojeck',
    '1402042': u'Gołymin-Ośrodek',
    '1402052': u'Grudusk',
    '1402062': u'Ojrzeń',
    '1402072': u'Opinogóra Górna',
    '1402082': u'Regimin',
    '1402092': u'Sońsk',
    '1403011': u'Garwolin',
    '1403021': u'Łaskarzew',
    '1403032': u'Borowie',
    '1403042': u'Garwolin',
    '1403052': u'Górzno',
    '1403062': u'Łaskarzew',
    '1403072': u'Maciejowice',
    '1403082': u'Miastków Kościelny',
    '1403092': u'Parysów',
    '1403103': u'Pilawa',
    '1403112': u'Sobolew',
    '1403122': u'Trojanów',
    '1403132': u'Wilga',
    '1403143': u'Żelechów',
    '1404011': u'Gostynin',
    '1404022': u'Gostynin',
    '1404032': u'Pacyna',
    '1404042': u'Sanniki',
    '1404052': u'Szczawin Kościelny',
    '1405011': u'Milanówek',
    '1405021': u'Podkowa Leśna',
    '1405032': u'Baranów',
    '1405043': u'Grodzisk Mazowiecki',
    '1405052': u'Jaktorów',
    '1405062': u'Żabia Wola',
    '1406012': u'Belsk Duży',
    '1406022': u'Błędów',
    '1406032': u'Chynów',
    '1406042': u'Goszczyn',
    '1406053': u'Grójec',
    '1406062': u'Jasieniec',
    '1406073': u'Mogielnica',
    '1406083': u'Nowe Miasto nad Pilicą',
    '1406092': u'Pniewy',
    '1406113': u'Warka',
    '1407012': u'Garbatka-Letnisko',
    '1407022': u'Głowaczów',
    '1407032': u'Gniewoszów',
    '1407042': u'Grabów nad Pilicą',
    '1407053': u'Kozienice',
    '1407062': u'Magnuszew',
    '1407072': u'Sieciechów',
    '1408011': u'Legionowo',
    '1408022': u'Jabłonna',
    '1408032': u'Nieporęt',
    '1408043': u'Serock',
    '1408052': u'Wieliszew',
    '1409012': u'Chotcza',
    '1409022': u'Ciepielów',
    '1409033': u'Lipsko',
    '1409042': u'Rzeczniów',
    '1409052': u'Sienno',
    '1409062': u'Solec nad Wisłą',
    '1410012': u'Huszlew',
    '1410023': u'Łosice',
    '1410032': u'Olszanka',
    '1410042': u'Platerów',
    '1410052': u'Sarnaki',
    '1410062': u'Stara Kornica',
    '1411011': u'Maków Mazowiecki',
    '1411022': u'Czerwonka',
    '1411032': u'Karniewo',
    '1411042': u'Krasnosielc',
    '1411052': u'Młynarze',
    '1411062': u'Płoniawy-Bramura',
    '1411073': u'Różan',
    '1411082': u'Rzewnie',
    '1411092': u'Sypniewo',
    '1411102': u'Szelków',
    '1412011': u'Mińsk Mazowiecki',
    '1412042': u'Cegłów',
    '1412052': u'Dębe Wielkie',
    '1412062': u'Dobre',
    '1412073': u'Halinów',
    '1412082': u'Jakubów',
    '1412093': u'Kałuszyn',
    '1412102': u'Latowicz',
    '1412112': u'Mińsk Mazowiecki',
    '1412122': u'Mrozy',
    '1412132': u'Siennica',
    '1412142': u'Stanisławów',
    '1412151': u'Sulejówek',
    '1413011': u'Mława',
    '1413022': u'Dzierzgowo',
    '1413032': u'Lipowiec Kościelny',
    '1413042': u'Radzanów',
    '1413052': u'Strzegowo',
    '1413062': u'Stupsk',
    '1413072': u'Szreńsk',
    '1413082': u'Szydłowo',
    '1413092': u'Wieczfnia Kościelna',
    '1413102': u'Wiśniewo',
    '1414011': u'Nowy Dwór Mazowiecki',
    '1414022': u'Czosnów',
    '1414032': u'Leoncin',
    '1414043': u'Nasielsk',
    '1414052': u'Pomiechówek',
    '1414063': u'Zakroczym',
    '1415012': u'Baranowo',
    '1415022': u'Czarnia',
    '1415032': u'Czerwin',
    '1415042': u'Goworowo',
    '1415052': u'Kadzidło',
    '1415062': u'Lelis',
    '1415072': u'Łyse',
    '1415083': u'Myszyniec',
    '1415092': u'Olszewo-Borki',
    '1415102': u'Rzekuń',
    '1415112': u'Troszyn',
    '1416011': u'Ostrów Mazowiecka',
    '1416022': u'Andrzejewo',
    '1416032': u'Boguty-Pianki',
    '1416043': u'Brok',
    '1416052': u'Małkinia Górna',
    '1416062': u'Nur',
    '1416072': u'Ostrów Mazowiecka',
    '1416082': u'Stary Lubotyń',
    '1416092': u'Szulborze Wielkie',
    '1416102': u'Wąsewo',
    '1416112': u'Zaręby Kościelne',
    '1417011': u'Józefów',
    '1417021': u'Otwock',
    '1417032': u'Celestynów',
    '1417043': u'Karczew',
    '1417052': u'Kołbiel',
    '1417062': u'Osieck',
    '1417072': u'Sobienie-Jeziory',
    '1417082': u'Wiązowna',
    '1418013': u'Góra Kalwaria',
    '1418023': u'Konstancin-Jeziorna',
    '1418032': u'Lesznowola',
    '1418043': u'Piaseczno',
    '1418052': u'Prażmów',
    '1418063': u'Tarczyn',
    '1419012': u'Bielsk',
    '1419022': u'Bodzanów',
    '1419032': u'Brudzeń Duży',
    '1419042': u'Bulkowo',
    '1419053': u'Drobin',
    '1419063': u'Gąbin',
    '1419072': u'Łąck',
    '1419082': u'Mała Wieś',
    '1419092': u'Nowy Duninów',
    '1419102': u'Radzanowo',
    '1419112': u'Słubice',
    '1419122': u'Słupno',
    '1419132': u'Stara Biała',
    '1419142': u'Staroźreby',
    '1419153': u'Wyszogród',
    '1420011': u'Płońsk',
    '1420021': u'Raciąż',
    '1420032': u'Baboszewo',
    '1420042': u'Czerwińsk nad Wisłą',
    '1420052': u'Dzierzążnia',
    '1420062': u'Joniec',
    '1420072': u'Naruszewo',
    '1420082': u'Nowe Miasto',
    '1420092': u'Płońsk',
    '1420102': u'Raciąż',
    '1420112': u'Sochocin',
    '1420122': u'Załuski',
    '1421011': u'Piastów',
    '1421021': u'Pruszków',
    '1421033': u'Brwinów',
    '1421042': u'Michałowice',
    '1421052': u'Nadarzyn',
    '1421062': u'Raszyn',
    '1422011': u'Przasnysz',
    '1422023': u'Chorzele',
    '1422032': u'Czernice Borowe',
    '1422042': u'Jednorożec',
    '1422052': u'Krasne',
    '1422062': u'Krzynowłoga Mała',
    '1422072': u'Przasnysz',
    '1423012': u'Borkowice',
    '1423022': u'Gielniów',
    '1423032': u'Klwów',
    '1423042': u'Odrzywół',
    '1423052': u'Potworów',
    '1423063': u'Przysucha',
    '1423072': u'Rusinów',
    '1423082': u'Wieniawa',
    '1424012': u'Gzy',
    '1424022': u'Obryte',
    '1424032': u'Pokrzywnica',
    '1424043': u'Pułtusk',
    '1424052': u'Świercze',
    '1424062': u'Winnica',
    '1424072': u'Zatory',
    '1425011': u'Pionki',
    '1425022': u'Gózd',
    '1425033': u'Iłża',
    '1425042': u'Jastrzębia',
    '1425052': u'Jedlińsk',
    '1425062': u'Jedlnia-Letnisko',
    '1425072': u'Kowala',
    '1425082': u'Pionki',
    '1425092': u'Przytyk',
    '1425103': u'Skaryszew',
    '1425112': u'Wierzbica',
    '1425122': u'Wolanów',
    '1425132': u'Zakrzew',
    '1426012': u'Domanice',
    '1426022': u'Korczew',
    '1426032': u'Kotuń',
    '1426042': u'Mokobody',
    '1426053': u'Mordy',
    '1426062': u'Paprotnia',
    '1426072': u'Przesmyki',
    '1426082': u'Siedlce',
    '1426092': u'Skórzec',
    '1426102': u'Suchożebry',
    '1426112': u'Wiśniew',
    '1426122': u'Wodynie',
    '1426132': u'Zbuczyn',
    '1427011': u'Sierpc',
    '1427022': u'Gozdowo',
    '1427032': u'Mochowo',
    '1427042': u'Rościszewo',
    '1427052': u'Sierpc',
    '1427062': u'Szczutowo',
    '1427072': u'Zawidz',
    '1428011': u'Sochaczew',
    '1428022': u'Brochów',
    '1428032': u'Iłów',
    '1428042': u'Młodzieszyn',
    '1428052': u'Nowa Sucha',
    '1428062': u'Rybno',
    '1428072': u'Sochaczew',
    '1428082': u'Teresin',
    '1429011': u'Sokołów Podlaski',
    '1429022': u'Bielany',
    '1429032': u'Ceranów',
    '1429042': u'Jabłonna Lacka',
    '1429053': u'Kosów Lacki',
    '1429062': u'Repki',
    '1429072': u'Sabnie',
    '1429082': u'Sokołów Podlaski',
    '1429092': u'Sterdyń',
    '1430012': u'Chlewiska',
    '1430022': u'Jastrząb',
    '1430032': u'Mirów',
    '1430042': u'Orońsko',
    '1430053': u'Szydłowiec',
    '1432013': u'Błonie',
    '1432022': u'Izabelin',
    '1432032': u'Kampinos',
    '1432042': u'Leszno',
    '1432053': u'Łomianki',
    '1432063': u'Ożarów Mazowiecki',
    '1432072': u'Stare Babice',
    '1433011': u'Węgrów',
    '1433022': u'Grębków',
    '1433032': u'Korytnica',
    '1433042': u'Liw',
    '1433053': u'Łochów',
    '1433062': u'Miedzna',
    '1433072': u'Sadowne',
    '1433082': u'Stoczek',
    '1433092': u'Wierzbno',
    '1434011': u'Kobyłka',
    '1434021': u'Marki',
    '1434031': u'Ząbki',
    '1434041': u'Zielonka',
    '1434052': u'Dąbrówka',
    '1434062': u'Jadów',
    '1434072': u'Klembów',
    '1434082': u'Poświętne',
    '1434093': u'Radzymin',
    '1434102': u'Strachówka',
    '1434113': u'Tłuszcz',
    '1434123': u'Wołomin',
    '1435012': u'Brańszczyk',
    '1435022': u'Długosiodło',
    '1435032': u'Rząśnik',
    '1435042': u'Somianka',
    '1435053': u'Wyszków',
    '1435062': u'Zabrodzie',
    '1436012': u'Kazanów',
    '1436022': u'Policzna',
    '1436032': u'Przyłęk',
    '1436042': u'Tczów',
    '1436053': u'Zwoleń',
    '1437013': u'Bieżuń',
    '1437022': u'Kuczbork-Osada',
    '1437032': u'Lubowidz',
    '1437042': u'Lutocin',
    '1437052': u'Siemiątkowo',
    '1437063': u'Żuromin',
    '1438011': u'Żyrardów',
    '1438023': u'Mszczonów',
    '1438032': u'Puszcza Mariańska',
    '1438042': u'Radziejowice',
    '1438052': u'Wiskitki',
    '1461011': u'Ostrołęka',
    '1462011': u'Płock',
    '1463011': u'Radom',
    '1464011': u'Siedlce',
    '1465011': u'Warszawa',
    '1465028': u'Bemowo',
    '1465038': u'Białołęka',
    '1465048': u'Bielany',
    '1465058': u'Mokotów',
    '1465068': u'Ochota',
    '1465078': u'Praga-Południe',
    '1465088': u'Praga-Północ',
    '1465098': u'Rembertów',
    '1465108': u'Śródmieście',
    '1465118': u'Targówek',
    '1465128': u'Ursus',
    '1465138': u'Ursynów',
    '1465148': u'Wawer',
    '1465158': u'Wesoła',
    '1465168': u'Wilanów',
    '1465178': u'Włochy',
    '1465188': u'Wola',
    '1465198': u'Żoliborz',
    '1601011': u'Brzeg',
    '1601022': u'Skarbimierz',
    '1601033': u'Grodków',
    '1601043': u'Lewin Brzeski',
    '1601052': u'Lubsza',
    '1601062': u'Olszanka',
    '1602013': u'Baborów',
    '1602022': u'Branice',
    '1602033': u'Głubczyce',
    '1602043': u'Kietrz',
    '1603011': u'Kędzierzyn-Koźle',
    '1603022': u'Bierawa',
    '1603032': u'Cisek',
    '1603042': u'Pawłowiczki',
    '1603052': u'Polska Cerekiew',
    '1603062': u'Reńska Wieś',
    '1604013': u'Byczyna',
    '1604023': u'Kluczbork',
    '1604032': u'Lasowice Wielkie',
    '1604043': u'Wołczyn',
    '1605013': u'Gogolin',
    '1605023': u'Krapkowice',
    '1605032': u'Strzeleczki',
    '1605042': u'Walce',
    '1605053': u'Zdzieszowice',
    '1606012': u'Domaszowice',
    '1606023': u'Namysłów',
    '1606032': u'Pokój',
    '1606042': u'Świerczów',
    '1606052': u'Wilków',
    '1607013': u'Głuchołazy',
    '1607022': u'Kamiennik',
    '1607033': u'Korfantów',
    '1607042': u'Łambinowice',
    '1607053': u'Nysa',
    '1607063': u'Otmuchów',
    '1607073': u'Paczków',
    '1607082': u'Pakosławice',
    '1607092': u'Skoroszyce',
    '1608013': u'Dobrodzień',
    '1608023': u'Gorzów Śląski',
    '1608033': u'Olesno',
    '1608043': u'Praszka',
    '1608052': u'Radłów',
    '1608062': u'Rudniki',
    '1608072': u'Zębowice',
    '1609012': u'Chrząstowice',
    '1609022': u'Dąbrowa',
    '1609032': u'Dobrzeń Wielki',
    '1609042': u'Komprachcice',
    '1609052': u'Łubniany',
    '1609062': u'Murów',
    '1609073': u'Niemodlin',
    '1609083': u'Ozimek',
    '1609092': u'Popielów',
    '1609103': u'Prószków',
    '1609112': u'Tarnów Opolski',
    '1609122': u'Tułowice',
    '1609132': u'Turawa',
    '1610013': u'Biała',
    '1610023': u'Głogówek',
    '1610032': u'Lubrza',
    '1610043': u'Prudnik',
    '1611012': u'Izbicko',
    '1611022': u'Jemielnica',
    '1611033': u'Kolonowskie',
    '1611043': u'Leśnica',
    '1611053': u'Strzelce Opolskie',
    '1611063': u'Ujazd',
    '1611073': u'Zawadzkie',
    '1661011': u'Opole',
    '1801032': u'Czarna',
    '1801052': u'Lutowiska',
    '1801083': u'Ustrzyki Dolne',
    '1802013': u'Brzozów',
    '1802022': u'Domaradz',
    '1802032': u'Dydnia',
    '1802042': u'Haczów',
    '1802052': u'Jasienica Rosielna',
    '1802062': u'Nozdrzec',
    '1803011': u'Dębica',
    '1803022': u'Brzostek',
    '1803032': u'Czarna',
    '1803042': u'Dębica',
    '1803052': u'Jodłowa',
    '1803063': u'Pilzno',
    '1803072': u'Żyraków',
    '1804011': u'Jarosław',
    '1804021': u'Radymno',
    '1804032': u'Chłopice',
    '1804042': u'Jarosław',
    '1804052': u'Laszki',
    '1804062': u'Pawłosiów',
    '1804072': u'Pruchnik',
    '1804082': u'Radymno',
    '1804092': u'Rokietnica',
    '1804102': u'Roźwienica',
    '1804112': u'Wiązownica',
    '1805011': u'Jasło',
    '1805022': u'Brzyska',
    '1805032': u'Dębowiec',
    '1805042': u'Jasło',
    '1805052': u'Kołaczyce',
    '1805062': u'Krempna',
    '1805072': u'Nowy Żmigród',
    '1805082': u'Osiek Jasielski',
    '1805092': u'Skołyszyn',
    '1805112': u'Tarnowiec',
    '1806012': u'Cmolas',
    '1806023': u'Kolbuszowa',
    '1806032': u'Majdan Królewski',
    '1806042': u'Niwiska',
    '1806052': u'Raniżów',
    '1806062': u'Dzikowiec',
    '1807012': u'Chorkówka',
    '1807023': u'Dukla',
    '1807033': u'Iwonicz-Zdrój',
    '1807043': u'Jedlicze',
    '1807052': u'Korczyna',
    '1807062': u'Krościenko Wyżne',
    '1807072': u'Miejsce Piastowe',
    '1807083': u'Rymanów',
    '1807092': u'Wojaszówka',
    '1808011': u'Leżajsk',
    '1808022': u'Grodzisko Dolne',
    '1808032': u'Kuryłówka',
    '1808042': u'Leżajsk',
    '1808053': u'Nowa Sarzyna',
    '1809011': u'Lubaczów',
    '1809023': u'Cieszanów',
    '1809032': u'Horyniec-Zdrój',
    '1809042': u'Lubaczów',
    '1809053': u'Narol',
    '1809063': u'Oleszyce',
    '1809072': u'Stary Dzików',
    '1809082': u'Wielkie Oczy',
    '1810011': u'Łańcut',
    '1810022': u'Białobrzegi',
    '1810032': u'Czarna',
    '1810042': u'Łańcut',
    '1810052': u'Markowa',
    '1810062': u'Rakszawa',
    '1810072': u'Żołynia',
    '1811011': u'Mielec',
    '1811022': u'Borowa',
    '1811032': u'Czermin',
    '1811042': u'Gawłuszowice',
    '1811052': u'Mielec',
    '1811062': u'Padew Narodowa',
    '1811072': u'Przecław',
    '1811083': u'Radomyśl Wielki',
    '1811092': u'Tuszów Narodowy',
    '1811102': u'Wadowice Górne',
    '1812012': u'Harasiuki',
    '1812022': u'Jarocin',
    '1812032': u'Jeżowe',
    '1812042': u'Krzeszów',
    '1812053': u'Nisko',
    '1812063': u'Rudnik nad Sanem',
    '1812073': u'Ulanów',
    '1813012': u'Bircza',
    '1813022': u'Dubiecko',
    '1813032': u'Fredropol',
    '1813042': u'Krasiczyn',
    '1813052': u'Krzywcza',
    '1813062': u'Medyka',
    '1813072': u'Orły',
    '1813082': u'Przemyśl',
    '1813092': u'Stubno',
    '1813102': u'Żurawica',
    '1814011': u'Przeworsk',
    '1814022': u'Adamówka',
    '1814032': u'Gać',
    '1814042': u'Jawornik Polski',
    '1814053': u'Kańczuga',
    '1814062': u'Przeworsk',
    '1814073': u'Sieniawa',
    '1814082': u'Tryńcza',
    '1814092': u'Zarzecze',
    '1815012': u'Iwierzyce',
    '1815022': u'Ostrów',
    '1815033': u'Ropczyce',
    '1815043': u'Sędziszów Małopolski',
    '1815052': u'Wielopole Skrzyńskie',
    '1816011': u'Dynów',
    '1816023': u'Błażowa',
    '1816033': u'Boguchwała',
    '1816042': u'Chmielnik',
    '1816052': u'Dynów',
    '1816063': u'Głogów Małopolski',
    '1816072': u'Hyżne',
    '1816082': u'Kamień',
    '1816092': u'Krasne',
    '1816102': u'Lubenia',
    '1816113': u'Sokołów Małopolski',
    '1816122': u'Świlcza',
    '1816132': u'Trzebownisko',
    '1816143': u'Tyczyn',
    '1817011': u'Sanok',
    '1817022': u'Besko',
    '1817032': u'Bukowsko',
    '1817042': u'Komańcza',
    '1817052': u'Sanok',
    '1817062': u'Tyrawa Wołoska',
    '1817073': u'Zagórz',
    '1817082': u'Zarszyn',
    '1818011': u'Stalowa Wola',
    '1818022': u'Bojanów',
    '1818032': u'Pysznica',
    '1818042': u'Radomyśl nad Sanem',
    '1818052': u'Zaklików',
    '1818062': u'Zaleszany',
    '1819012': u'Czudec',
    '1819022': u'Frysztak',
    '1819032': u'Niebylec',
    '1819043': u'Strzyżów',
    '1819052': u'Wiśniowa',
    '1820013': u'Baranów Sandomierski',
    '1820022': u'Gorzyce',
    '1820032': u'Grębów',
    '1820043': u'Nowa Dęba',
    '1821012': u'Baligród',
    '1821022': u'Cisna',
    '1821033': u'Lesko',
    '1821042': u'Olszanica',
    '1821052': u'Solina',
    '1861011': u'Krosno',
    '1862011': u'Przemyśl',
    '1863011': u'Rzeszów',
    '1864011': u'Tarnobrzeg',
    '2001011': u'Augustów',
    '2001022': u'Augustów',
    '2001032': u'Bargłów Kościelny',
    '2001043': u'Lipsk',
    '2001052': u'Nowinka',
    '2001062': u'Płaska',
    '2001072': u'Sztabin',
    '2002013': u'Choroszcz',
    '2002023': u'Czarna Białostocka',
    '2002032': u'Dobrzyniewo Duże',
    '2002042': u'Gródek',
    '2002052': u'Juchnowiec Kościelny',
    '2002063': u'Łapy',
    '2002072': u'Michałowo',
    '2002082': u'Poświętne',
    '2002093': u'Supraśl',
    '2002103': u'Suraż',
    '2002112': u'Turośń Kościelna',
    '2002123': u'Tykocin',
    '2002133': u'Wasilków',
    '2002143': u'Zabłudów',
    '2002152': u'Zawady',
    '2003011': u'Bielsk Podlaski',
    '2003021': u'Brańsk',
    '2003032': u'Bielsk Podlaski',
    '2003042': u'Boćki',
    '2003052': u'Brańsk',
    '2003062': u'Orla',
    '2003072': u'Rudka',
    '2003082': u'Wyszki',
    '2004011': u'Grajewo',
    '2004022': u'Grajewo',
    '2004032': u'Radziłów',
    '2004043': u'Rajgród',
    '2004053': u'Szczuczyn',
    '2004062': u'Wąsosz',
    '2005011': u'Hajnówka',
    '2005022': u'Białowieża',
    '2005032': u'Czeremcha',
    '2005042': u'Czyże',
    '2005052': u'Dubicze Cerkiewne',
    '2005062': u'Hajnówka',
    '2005073': u'Kleszczele',
    '2005082': u'Narew',
    '2005092': u'Narewka',
    '2006011': u'Kolno',
    '2006022': u'Grabowo',
    '2006032': u'Kolno',
    '2006042': u'Mały Płock',
    '2006053': u'Stawiski',
    '2006062': u'Turośl',
    '2007013': u'Jedwabne',
    '2007022': u'Łomża',
    '2007032': u'Miastkowo',
    '2007043': u'Nowogród',
    '2007052': u'Piątnica',
    '2007062': u'Przytuły',
    '2007072': u'Śniadowo',
    '2007082': u'Wizna',
    '2007092': u'Zbójna',
    '2008013': u'Goniądz',
    '2008022': u'Jasionówka',
    '2008032': u'Jaświły',
    '2008043': u'Knyszyn',
    '2008052': u'Krypno',
    '2008063': u'Mońki',
    '2008072': u'Trzcianne',
    '2009011': u'Sejny',
    '2009022': u'Giby',
    '2009032': u'Krasnopol',
    '2009042': u'Puńsk',
    '2009052': u'Sejny',
    '2010011': u'Siemiatycze',
    '2010023': u'Drohiczyn',
    '2010032': u'Dziadkowice',
    '2010042': u'Grodzisk',
    '2010052': u'Mielnik',
    '2010062': u'Milejczyce',
    '2010072': u'Nurzec-Stacja',
    '2010082': u'Perlejewo',
    '2010092': u'Siemiatycze',
    '2011013': u'Dąbrowa Białostocka',
    '2011022': u'Janów',
    '2011032': u'Korycin',
    '2011042': u'Krynki',
    '2011052': u'Kuźnica',
    '2011062': u'Nowy Dwór',
    '2011072': u'Sidra',
    '2011083': u'Sokółka',
    '2011093': u'Suchowola',
    '2011102': u'Szudziałowo',
    '2012012': u'Bakałarzewo',
    '2012022': u'Filipów',
    '2012032': u'Jeleniewo',
    '2012042': u'Przerośl',
    '2012052': u'Raczki',
    '2012062': u'Rutka-Tartak',
    '2012072': u'Suwałki',
    '2012082': u'Szypliszki',
    '2012092': u'Wiżajny',
    '2013011': u'Wysokie Mazowieckie',
    '2013023': u'Ciechanowiec',
    '2013032': u'Czyżew-Osada',
    '2013042': u'Klukowo',
    '2013052': u'Kobylin-Borzymy',
    '2013062': u'Kulesze Kościelne',
    '2013072': u'Nowe Piekuty',
    '2013082': u'Sokoły',
    '2013092': u'Szepietowo',
    '2013102': u'Wysokie Mazowieckie',
    '2014011': u'Zambrów',
    '2014022': u'Kołaki Kościelne',
    '2014032': u'Rutki',
    '2014042': u'Szumowo',
    '2014052': u'Zambrów',
    '2061011': u'Białystok',
    '2062011': u'Łomża',
    '2063011': u'Suwałki',
    '2201012': u'Borzytuchom',
    '2201023': u'Bytów',
    '2201032': u'Czarna Dąbrówka',
    '2201042': u'Kołczygłowy',
    '2201052': u'Lipnica',
    '2201063': u'Miastko',
    '2201072': u'Parchowo',
    '2201082': u'Studzienice',
    '2201092': u'Trzebielino',
    '2201102': u'Tuchomie',
    '2202011': u'Chojnice',
    '2202023': u'Brusy',
    '2202032': u'Chojnice',
    '2202043': u'Czersk',
    '2202052': u'Konarzyny',
    '2203011': u'Człuchów',
    '2203023': u'Czarne',
    '2203032': u'Człuchów',
    '2203043': u'Debrzno',
    '2203052': u'Koczała',
    '2203062': u'Przechlewo',
    '2203072': u'Rzeczenica',
    '2204011': u'Pruszcz Gdański',
    '2204022': u'Cedry Wielkie',
    '2204032': u'Kolbudy',
    '2204042': u'Pruszcz Gdański',
    '2204052': u'Przywidz',
    '2204062': u'Pszczółki',
    '2204072': u'Suchy Dąb',
    '2204082': u'Trąbki Wielkie',
    '2205012': u'Chmielno',
    '2205023': u'Kartuzy',
    '2205032': u'Przodkowo',
    '2205042': u'Sierakowice',
    '2205052': u'Somonino',
    '2205062': u'Stężyca',
    '2205072': u'Sulęczyno',
    '2205083': u'Żukowo',
    '2206011': u'Kościerzyna',
    '2206022': u'Dziemiany',
    '2206032': u'Karsin',
    '2206042': u'Kościerzyna',
    '2206052': u'Liniewo',
    '2206062': u'Lipusz',
    '2206072': u'Nowa Karczma',
    '2206082': u'Stara Kiszewa',
    '2207011': u'Kwidzyn',
    '2207022': u'Gardeja',
    '2207032': u'Kwidzyn',
    '2207043': u'Prabuty',
    '2207052': u'Ryjewo',
    '2207062': u'Sadlinki',
    '2208011': u'Lębork',
    '2208021': u'Łeba',
    '2208032': u'Cewice',
    '2208042': u'Nowa Wieś Lęborska',
    '2208052': u'Wicko',
    '2209011': u'Malbork',
    '2209032': u'Lichnowy',
    '2209042': u'Malbork',
    '2209062': u'Miłoradz',
    '2209073': u'Nowy Staw',
    '2209082': u'Stare Pole',
    '2210011': u'Krynica Morska',
    '2210023': u'Nowy Dwór Gdański',
    '2210032': u'Ostaszewo',
    '2210042': u'Stegna',
    '2210052': u'Sztutowo',
    '2211011': u'Hel',
    '2211021': u'Jastarnia',
    '2211031': u'Puck',
    '2211041': u'Władysławowo',
    '2211052': u'Kosakowo',
    '2211062': u'Krokowa',
    '2211072': u'Puck',
    '2212011': u'Ustka',
    '2212022': u'Damnica',
    '2212032': u'Dębnica Kaszubska',
    '2212042': u'Główczyce',
    '2212053': u'Kępice',
    '2212062': u'Kobylnica',
    '2212072': u'Potęgowo',
    '2212082': u'Słupsk',
    '2212092': u'Smołdzino',
    '2212102': u'Ustka',
    '2213011': u'Czarna Woda',
    '2213021': u'Skórcz',
    '2213031': u'Starogard Gdański',
    '2213042': u'Bobowo',
    '2213052': u'Kaliska',
    '2213062': u'Lubichowo',
    '2213072': u'Osieczna',
    '2213082': u'Osiek',
    '2213093': u'Skarszewy',
    '2213102': u'Skórcz',
    '2213112': u'Smętowo Graniczne',
    '2213122': u'Starogard Gdański',
    '2213132': u'Zblewo',
    '2214011': u'Tczew',
    '2214023': u'Gniew',
    '2214032': u'Morzeszczyn',
    '2214043': u'Pelplin',
    '2214052': u'Subkowy',
    '2214062': u'Tczew',
    '2215011': u'Reda',
    '2215021': u'Rumia',
    '2215031': u'Wejherowo',
    '2215042': u'Choczewo',
    '2215052': u'Gniewino',
    '2215062': u'Linia',
    '2215072': u'Luzino',
    '2215082': u'Łęczyce',
    '2215092': u'Szemud',
    '2215102': u'Wejherowo',
    '2216013': u'Dzierzgoń',
    '2216022': u'Mikołajki Pomorskie',
    '2216032': u'Stary Dzierzgoń',
    '2216042': u'Stary Targ',
    '2216053': u'Sztum',
    '2261011': u'Gdańsk',
    '2262011': u'Gdynia',
    '2263011': u'Słupsk',
    '2264011': u'Sopot',
    '2401011': u'Będzin',
    '2401021': u'Czeladź',
    '2401031': u'Wojkowice',
    '2401042': u'Bobrowniki',
    '2401052': u'Mierzęcice',
    '2401062': u'Psary',
    '2401073': u'Siewierz',
    '2401081': u'Sławków',
    '2402011': u'Szczyrk',
    '2402022': u'Bestwina',
    '2402032': u'Buczkowice',
    '2402043': u'Czechowice-Dziedzice',
    '2402052': u'Jasienica',
    '2402062': u'Jaworze',
    '2402072': u'Kozy',
    '2402082': u'Porąbka',
    '2402093': u'Wilamowice',
    '2402102': u'Wilkowice',
    '2403011': u'Cieszyn',
    '2403021': u'Ustroń',
    '2403031': u'Wisła',
    '2403042': u'Brenna',
    '2403052': u'Chybie',
    '2403062': u'Dębowiec',
    '2403072': u'Goleszów',
    '2403082': u'Hażlach',
    '2403092': u'Istebna',
    '2403103': u'Skoczów',
    '2403113': u'Strumień',
    '2403122': u'Zebrzydowice',
    '2404013': u'Blachownia',
    '2404022': u'Dąbrowa Zielona',
    '2404032': u'Janów',
    '2404042': u'Kamienica Polska',
    '2404052': u'Kłomnice',
    '2404063': u'Koniecpol',
    '2404072': u'Konopiska',
    '2404082': u'Kruszyna',
    '2404092': u'Lelów',
    '2404102': u'Mstów',
    '2404112': u'Mykanów',
    '2404122': u'Olsztyn',
    '2404132': u'Poczesna',
    '2404142': u'Przyrów',
    '2404152': u'Rędziny',
    '2404162': u'Starcza',
    '2405011': u'Knurów',
    '2405021': u'Pyskowice',
    '2405032': u'Gierałtowice',
    '2405042': u'Pilchowice',
    '2405052': u'Rudziniec',
    '2405063': u'Sośnicowice',
    '2405073': u'Toszek',
    '2405082': u'Wielowieś',
    '2406013': u'Kłobuck',
    '2406023': u'Krzepice',
    '2406032': u'Lipie',
    '2406042': u'Miedźno',
    '2406052': u'Opatów',
    '2406062': u'Panki',
    '2406072': u'Popów',
    '2406082': u'Przystajń',
    '2406092': u'Wręczyca Wielka',
    '2407011': u'Lubliniec',
    '2407022': u'Boronów',
    '2407032': u'Ciasna',
    '2407042': u'Herby',
    '2407052': u'Kochanowice',
    '2407062': u'Koszęcin',
    '2407072': u'Pawonków',
    '2407083': u'Woźniki',
    '2408011': u'Łaziska Górne',
    '2408021': u'Mikołów',
    '2408031': u'Orzesze',
    '2408042': u'Ornontowice',
    '2408052': u'Wyry',
    '2409011': u'Myszków',
    '2409023': u'Koziegłowy',
    '2409032': u'Niegowa',
    '2409042': u'Poraj',
    '2409053': u'Żarki',
    '2410012': u'Goczałkowice-Zdrój',
    '2410022': u'Kobiór',
    '2410032': u'Miedźna',
    '2410042': u'Pawłowice',
    '2410053': u'Pszczyna',
    '2410062': u'Suszec',
    '2411011': u'Racibórz',
    '2411022': u'Kornowac',
    '2411033': u'Krzanowice',
    '2411042': u'Krzyżanowice',
    '2411053': u'Kuźnia Raciborska',
    '2411062': u'Nędza',
    '2411072': u'Pietrowice Wielkie',
    '2411082': u'Rudnik',
    '2412013': u'Czerwionka-Leszczyny',
    '2412022': u'Gaszowice',
    '2412032': u'Jejkowice',
    '2412042': u'Lyski',
    '2412052': u'Świerklany',
    '2413011': u'Kalety',
    '2413021': u'Miasteczko Śląskie',
    '2413031': u'Radzionków',
    '2413041': u'Tarnowskie Góry',
    '2413052': u'Krupski Młyn',
    '2413062': u'Ożarowice',
    '2413072': u'Świerklaniec',
    '2413082': u'Tworóg',
    '2413092': u'Zbrosławice',
    '2414011': u'Bieruń',
    '2414021': u'Imielin',
    '2414031': u'Lędziny',
    '2414042': u'Bojszowy',
    '2414052': u'Chełm Śląski',
    '2415011': u'Pszów',
    '2415021': u'Radlin',
    '2415031': u'Rydułtowy',
    '2415041': u'Wodzisław Śląski',
    '2415052': u'Godów',
    '2415062': u'Gorzyce',
    '2415072': u'Lubomia',
    '2415082': u'Marklowice',
    '2415092': u'Mszana',
    '2416011': u'Poręba',
    '2416021': u'Zawiercie',
    '2416032': u'Irządze',
    '2416042': u'Kroczyce',
    '2416053': u'Łazy',
    '2416063': u'Ogrodzieniec',
    '2416073': u'Pilica',
    '2416083': u'Szczekociny',
    '2416092': u'Włodowice',
    '2416102': u'Żarnowiec',
    '2417011': u'Żywiec',
    '2417022': u'Czernichów',
    '2417032': u'Gilowice',
    '2417042': u'Jeleśnia',
    '2417052': u'Koszarawa',
    '2417062': u'Lipowa',
    '2417072': u'Łękawica',
    '2417082': u'Łodygowice',
    '2417092': u'Milówka',
    '2417102': u'Radziechowy-Wieprz',
    '2417112': u'Rajcza',
    '2417122': u'Ślemień',
    '2417132': u'Świnna',
    '2417142': u'Ujsoły',
    '2417152': u'Węgierska Górka',
    '2461011': u'Bielsko-Biała',
    '2462011': u'Bytom',
    '2463011': u'Chorzów',
    '2464011': u'Częstochowa',
    '2465011': u'Dąbrowa Górnicza',
    '2466011': u'Gliwice',
    '2467011': u'Jastrzębie-Zdrój',
    '2468011': u'Jaworzno',
    '2469011': u'Katowice',
    '2470011': u'Mysłowice',
    '2471011': u'Piekary Śląskie',
    '2472011': u'Ruda Śląska',
    '2473011': u'Rybnik',
    '2474011': u'Siemianowice Śląskie',
    '2475011': u'Sosnowiec',
    '2476011': u'Świętochłowice',
    '2477011': u'Tychy',
    '2478011': u'Zabrze',
    '2479011': u'Żory',
    '2601013': u'Busko-Zdrój',
    '2601022': u'Gnojno',
    '2601032': u'Nowy Korczyn',
    '2601042': u'Pacanów',
    '2601052': u'Solec-Zdrój',
    '2601062': u'Stopnica',
    '2601072': u'Tuczępy',
    '2601082': u'Wiślica',
    '2602012': u'Imielno',
    '2602023': u'Jędrzejów',
    '2602033': u'Małogoszcz',
    '2602042': u'Nagłowice',
    '2602052': u'Oksa',
    '2602063': u'Sędziszów',
    '2602072': u'Słupia (Jędrzejowska)',
    '2602082': u'Sobków',
    '2602092': u'Wodzisław',
    '2603012': u'Bejsce',
    '2603022': u'Czarnocin',
    '2603033': u'Kazimierza Wielka',
    '2603042': u'Opatowiec',
    '2603053': u'Skalbmierz',
    '2604012': u'Bieliny',
    '2604023': u'Bodzentyn',
    '2604033': u'Chęciny',
    '2604043': u'Chmielnik',
    '2604053': u'Daleszyce',
    '2604062': u'Górno',
    '2604072': u'Łagów',
    '2604082': u'Łopuszno',
    '2604092': u'Masłów',
    '2604102': u'Miedziana Góra',
    '2604112': u'Mniów',
    '2604122': u'Morawica',
    '2604132': u'Nowa Słupia',
    '2604142': u'Piekoszów',
    '2604152': u'Pierzchnica',
    '2604162': u'Raków',
    '2604172': u'Sitkówka-Nowiny',
    '2604182': u'Strawczyn',
    '2604192': u'Zagnańsk',
    '2605012': u'Fałków',
    '2605022': u'Gowarczów',
    '2605033': u'Końskie',
    '2605042': u'Radoszyce',
    '2605052': u'Ruda Maleniecka',
    '2605062': u'Słupia (Konecka)',
    '2605072': u'Smyków',
    '2605083': u'Stąporków',
    '2606012': u'Baćkowice',
    '2606022': u'Iwaniska',
    '2606032': u'Lipnik',
    '2606043': u'Opatów',
    '2606053': u'Ożarów',
    '2606062': u'Sadowie',
    '2606072': u'Tarłów',
    '2606082': u'Wojciechowice',
    '2607011': u'Ostrowiec Świętokrzyski',
    '2607022': u'Bałtów',
    '2607032': u'Bodzechów',
    '2607043': u'Ćmielów',
    '2607053': u'Kunów',
    '2607062': u'Waśniów',
    '2608013': u'Działoszyce',
    '2608022': u'Kije',
    '2608032': u'Michałów',
    '2608043': u'Pińczów',
    '2608052': u'Złota',
    '2609011': u'Sandomierz',
    '2609022': u'Dwikozy',
    '2609032': u'Klimontów',
    '2609043': u'Koprzywnica',
    '2609052': u'Łoniów',
    '2609062': u'Obrazów',
    '2609072': u'Samborzec',
    '2609082': u'Wilczyce',
    '2609093': u'Zawichost',
    '2610011': u'Skarżysko-Kamienna',
    '2610022': u'Bliżyn',
    '2610032': u'Łączna',
    '2610042': u'Skarżysko Kościelne',
    '2610053': u'Suchedniów',
    '2611011': u'Starachowice',
    '2611022': u'Brody',
    '2611032': u'Mirzec',
    '2611042': u'Pawłów',
    '2611053': u'Wąchock',
    '2612012': u'Bogoria',
    '2612022': u'Łubnice',
    '2612032': u'Oleśnica',
    '2612043': u'Osiek',
    '2612053': u'Połaniec',
    '2612062': u'Rytwiany',
    '2612073': u'Staszów',
    '2612082': u'Szydłów',
    '2613012': u'Kluczewsko',
    '2613022': u'Krasocin',
    '2613032': u'Moskorzew',
    '2613042': u'Radków',
    '2613052': u'Secemin',
    '2613063': u'Włoszczowa',
    '2661011': u'Kielce',
    '2801011': u'Bartoszyce',
    '2801021': u'Górowo Iławeckie',
    '2801032': u'Bartoszyce',
    '2801043': u'Bisztynek',
    '2801052': u'Górowo Iławeckie',
    '2801063': u'Sępopol',
    '2802011': u'Braniewo',
    '2802022': u'Braniewo',
    '2802033': u'Frombork',
    '2802042': u'Lelkowo',
    '2802053': u'Pieniężno',
    '2802062': u'Płoskinia',
    '2802072': u'Wilczęta',
    '2803011': u'Działdowo',
    '2803022': u'Działdowo',
    '2803032': u'Iłowo-Osada',
    '2803043': u'Lidzbark',
    '2803052': u'Płośnica',
    '2803062': u'Rybno',
    '2804012': u'Elbląg',
    '2804022': u'Godkowo',
    '2804032': u'Gronowo Elbląskie',
    '2804042': u'Markusy',
    '2804052': u'Milejewo',
    '2804063': u'Młynary',
    '2804073': u'Pasłęk',
    '2804082': u'Rychliki',
    '2804093': u'Tolkmicko',
    '2805011': u'Ełk',
    '2805022': u'Ełk',
    '2805032': u'Kalinowo',
    '2805042': u'Prostki',
    '2805052': u'Stare Juchy',
    '2806011': u'Giżycko',
    '2806042': u'Giżycko',
    '2806052': u'Kruklanki',
    '2806062': u'Miłki',
    '2806083': u'Ryn',
    '2806102': u'Wydminy',
    '2807011': u'Iława',
    '2807021': u'Lubawa',
    '2807032': u'Iława',
    '2807043': u'Kisielice',
    '2807052': u'Lubawa',
    '2807063': u'Susz',
    '2807073': u'Zalewo',
    '2808011': u'Kętrzyn',
    '2808022': u'Barciany',
    '2808032': u'Kętrzyn',
    '2808043': u'Korsze',
    '2808053': u'Reszel',
    '2808062': u'Srokowo',
    '2809011': u'Lidzbark Warmiński',
    '2809022': u'Kiwity',
    '2809032': u'Lidzbark Warmiński',
    '2809042': u'Lubomino',
    '2809053': u'Orneta',
    '2810011': u'Mrągowo',
    '2810023': u'Mikołajki',
    '2810032': u'Mrągowo',
    '2810042': u'Piecki',
    '2810052': u'Sorkwity',
    '2811012': u'Janowiec Kościelny',
    '2811022': u'Janowo',
    '2811032': u'Kozłowo',
    '2811043': u'Nidzica',
    '2812011': u'Nowe Miasto Lubawskie',
    '2812022': u'Biskupiec',
    '2812032': u'Grodziczno',
    '2812042': u'Kurzętnik',
    '2812052': u'Nowe Miasto Lubawskie',
    '2813032': u'Kowale Oleckie',
    '2813043': u'Olecko',
    '2813052': u'Świętajno',
    '2813062': u'Wieliczki',
    '2814013': u'Barczewo',
    '2814023': u'Biskupiec',
    '2814033': u'Dobre Miasto',
    '2814042': u'Dywity',
    '2814052': u'Gietrzwałd',
    '2814063': u'Jeziorany',
    '2814072': u'Jonkowo',
    '2814082': u'Kolno',
    '2814093': u'Olsztynek',
    '2814102': u'Purda',
    '2814112': u'Stawiguda',
    '2814122': u'Świątki',
    '2815011': u'Ostróda',
    '2815022': u'Dąbrówno',
    '2815032': u'Grunwald',
    '2815042': u'Łukta',
    '2815052': u'Małdyty',
    '2815063': u'Miłakowo',
    '2815073': u'Miłomłyn',
    '2815083': u'Morąg',
    '2815092': u'Ostróda',
    '2816013': u'Biała Piska',
    '2816023': u'Orzysz',
    '2816033': u'Pisz',
    '2816043': u'Ruciane-Nida',
    '2817011': u'Szczytno',
    '2817022': u'Dźwierzuty',
    '2817032': u'Jedwabno',
    '2817043': u'Pasym',
    '2817052': u'Rozogi',
    '2817062': u'Szczytno',
    '2817072': u'Świętajno',
    '2817082': u'Wielbark',
    '2818012': u'Banie Mazurskie',
    '2818022': u'Dubeninki',
    '2818033': u'Gołdap',
    '2819012': u'Budry',
    '2819022': u'Pozezdrze',
    '2819033': u'Węgorzewo',
    '2861011': u'Elbląg',
    '2862011': u'Olsztyn',
    '3001011': u'Chodzież',
    '3001022': u'Budzyń',
    '3001032': u'Chodzież',
    '3001043': u'Margonin',
    '3001053': u'Szamocin',
    '3002011': u'Czarnków',
    '3002022': u'Czarnków',
    '3002032': u'Drawsko',
    '3002043': u'Krzyż Wielkopolski',
    '3002052': u'Lubasz',
    '3002062': u'Połajewo',
    '3002073': u'Trzcianka',
    '3002083': u'Wieleń',
    '3003011': u'Gniezno',
    '3003023': u'Czerniejewo',
    '3003032': u'Gniezno',
    '3003042': u'Kiszkowo',
    '3003053': u'Kłecko',
    '3003062': u'Łubowo',
    '3003072': u'Mieleszyn',
    '3003082': u'Niechanowo',
    '3003093': u'Trzemeszno',
    '3003103': u'Witkowo',
    '3004013': u'Borek Wielkopolski',
    '3004023': u'Gostyń',
    '3004033': u'Krobia',
    '3004042': u'Pępowo',
    '3004052': u'Piaski',
    '3004063': u'Pogorzela',
    '3004073': u'Poniec',
    '3005012': u'Granowo',
    '3005023': u'Grodzisk Wielkopolski',
    '3005032': u'Kamieniec',
    '3005043': u'Rakoniewice',
    '3005053': u'Wielichowo',
    '3006012': u'Jaraczewo',
    '3006023': u'Jarocin',
    '3006032': u'Kotlin',
    '3006043': u'Żerków',
    '3007012': u'Blizanów',
    '3007022': u'Brzeziny',
    '3007032': u'Ceków-Kolonia',
    '3007042': u'Godziesze Wielkie',
    '3007052': u'Koźminek',
    '3007062': u'Lisków',
    '3007072': u'Mycielin',
    '3007082': u'Opatówek',
    '3007093': u'Stawiszyn',
    '3007102': u'Szczytniki',
    '3007112': u'Żelazków',
    '3008012': u'Baranów',
    '3008022': u'Bralin',
    '3008033': u'Kępno',
    '3008042': u'Łęka Opatowska',
    '3008052': u'Perzów',
    '3008062': u'Rychtal',
    '3008072': u'Trzcinica',
    '3009011': u'Koło',
    '3009022': u'Babiak',
    '3009032': u'Chodów',
    '3009043': u'Dąbie',
    '3009052': u'Grzegorzew',
    '3009063': u'Kłodawa',
    '3009072': u'Koło',
    '3009082': u'Kościelec',
    '3009092': u'Olszówka',
    '3009102': u'Osiek Mały',
    '3009113': u'Przedecz',
    '3010013': u'Golina',
    '3010022': u'Grodziec',
    '3010032': u'Kazimierz Biskupi',
    '3010043': u'Kleczew',
    '3010052': u'Kramsk',
    '3010062': u'Krzymów',
    '3010073': u'Rychwał',
    '3010082': u'Rzgów',
    '3010092': u'Skulsk',
    '3010103': u'Sompolno',
    '3010112': u'Stare Miasto',
    '3010123': u'Ślesin',
    '3010132': u'Wierzbinek',
    '3010142': u'Wilczyn',
    '3011011': u'Kościan',
    '3011023': u'Czempiń',
    '3011032': u'Kościan',
    '3011043': u'Krzywiń',
    '3011053': u'Śmigiel',
    '3012011': u'Sulmierzyce',
    '3012023': u'Kobylin',
    '3012033': u'Koźmin Wielkopolski',
    '3012043': u'Krotoszyn',
    '3012052': u'Rozdrażew',
    '3012063': u'Zduny',
    '3013012': u'Krzemieniewo',
    '3013022': u'Lipno',
    '3013033': u'Osieczna',
    '3013043': u'Rydzyna',
    '3013052': u'Święciechowa',
    '3013062': u'Wijewo',
    '3013072': u'Włoszakowice',
    '3014012': u'Chrzypsko Wielkie',
    '3014022': u'Kwilcz',
    '3014033': u'Międzychód',
    '3014043': u'Sieraków',
    '3015012': u'Kuślin',
    '3015023': u'Lwówek',
    '3015032': u'Miedzichowo',
    '3015043': u'Nowy Tomyśl',
    '3015053': u'Opalenica',
    '3015063': u'Zbąszyń',
    '3016013': u'Oborniki',
    '3016023': u'Rogoźno',
    '3016032': u'Ryczywół',
    '3017011': u'Ostrów Wielkopolski',
    '3017023': u'Nowe Skalmierzyce',
    '3017033': u'Odolanów',
    '3017042': u'Ostrów Wielkopolski',
    '3017052': u'Przygodzice',
    '3017063': u'Raszków',
    '3017072': u'Sieroszewice',
    '3017082': u'Sośnie',
    '3018012': u'Czajków',
    '3018022': u'Doruchów',
    '3018033': u'Grabów nad Prosną',
    '3018042': u'Kobyla Góra',
    '3018052': u'Kraszewice',
    '3018063': u'Mikstat',
    '3018073': u'Ostrzeszów',
    '3019011': u'Piła',
    '3019022': u'Białośliwie',
    '3019032': u'Kaczory',
    '3019043': u'Łobżenica',
    '3019052': u'Miasteczko Krajeńskie',
    '3019062': u'Szydłowo',
    '3019073': u'Ujście',
    '3019083': u'Wyrzysk',
    '3019093': u'Wysoka',
    '3020012': u'Chocz',
    '3020022': u'Czermin',
    '3020032': u'Dobrzyca',
    '3020042': u'Gizałki',
    '3020052': u'Gołuchów',
    '3020063': u'Pleszew',
    '3021011': u'Luboń',
    '3021021': u'Puszczykowo',
    '3021033': u'Buk',
    '3021042': u'Czerwonak',
    '3021052': u'Dopiewo',
    '3021062': u'Kleszczewo',
    '3021072': u'Komorniki',
    '3021083': u'Kostrzyn',
    '3021093': u'Kórnik',
    '3021103': u'Mosina',
    '3021113': u'Murowana Goślina',
    '3021123': u'Pobiedziska',
    '3021132': u'Rokietnica',
    '3021143': u'Stęszew',
    '3021152': u'Suchy Las',
    '3021163': u'Swarzędz',
    '3021172': u'Tarnowo Podgórne',
    '3022013': u'Bojanowo',
    '3022023': u'Jutrosin',
    '3022033': u'Miejska Górka',
    '3022042': u'Pakosław',
    '3022053': u'Rawicz',
    '3023011': u'Słupca',
    '3023022': u'Lądek',
    '3023032': u'Orchowo',
    '3023042': u'Ostrowite',
    '3023052': u'Powidz',
    '3023062': u'Słupca',
    '3023072': u'Strzałkowo',
    '3023083': u'Zagórów',
    '3024011': u'Obrzycko',
    '3024022': u'Duszniki',
    '3024032': u'Kaźmierz',
    '3024042': u'Obrzycko',
    '3024053': u'Ostroróg',
    '3024063': u'Pniewy',
    '3024073': u'Szamotuły',
    '3024083': u'Wronki',
    '3025012': u'Dominowo',
    '3025022': u'Krzykosy',
    '3025032': u'Nowe Miasto nad Wartą',
    '3025043': u'Środa Wielkopolska',
    '3025052': u'Zaniemyśl',
    '3026012': u'Brodnica',
    '3026023': u'Dolsk',
    '3026033': u'Książ Wielkopolski',
    '3026043': u'Śrem',
    '3027011': u'Turek',
    '3027022': u'Brudzew',
    '3027033': u'Dobra',
    '3027042': u'Kawęczyn',
    '3027052': u'Malanów',
    '3027062': u'Przykona',
    '3027073': u'Tuliszków',
    '3027082': u'Turek',
    '3027092': u'Władysławów',
    '3028011': u'Wągrowiec',
    '3028022': u'Damasławek',
    '3028033': u'Gołańcz',
    '3028042': u'Mieścisko',
    '3028053': u'Skoki',
    '3028062': u'Wapno',
    '3028072': u'Wągrowiec',
    '3029012': u'Przemęt',
    '3029022': u'Siedlec',
    '3029033': u'Wolsztyn',
    '3030012': u'Kołaczkowo',
    '3030023': u'Miłosław',
    '3030033': u'Nekla',
    '3030043': u'Pyzdry',
    '3030053': u'Września',
    '3031011': u'Złotów',
    '3031023': u'Jastrowie',
    '3031033': u'Krajenka',
    '3031042': u'Lipka',
    '3031053': u'Okonek',
    '3031062': u'Tarnówka',
    '3031072': u'Zakrzewo',
    '3031082': u'Złotów',
    '3061011': u'Kalisz',
    '3062011': u'Konin',
    '3063011': u'Leszno',
    '3064011': u'Poznań',
    '3064029': u'Poznań-Grunwald',
    '3064039': u'Poznań-Jeżyce',
    '3064049': u'Poznań-Nowe Miasto',
    '3064059': u'Poznań-Stare Miasto',
    '3064069': u'Poznań-Wilda',
    '3201011': u'Białogard',
    '3201022': u'Białogard',
    '3201033': u'Karlino',
    '3201042': u'Tychowo',
    '3202012': u'Bierzwnik',
    '3202023': u'Choszczno',
    '3202033': u'Drawno',
    '3202042': u'Krzęcin',
    '3202053': u'Pełczyce',
    '3202063': u'Recz',
    '3203013': u'Czaplinek',
    '3203023': u'Drawsko Pomorskie',
    '3203033': u'Kalisz Pomorski',
    '3203042': u'Ostrowice',
    '3203052': u'Wierzchowo',
    '3203063': u'Złocieniec',
    '3204023': u'Goleniów',
    '3204033': u'Maszewo',
    '3204043': u'Nowogard',
    '3204052': u'Osina',
    '3204062': u'Przybiernów',
    '3204072': u'Stepnica',
    '3205012': u'Brojce',
    '3205023': u'Gryfice',
    '3205032': u'Karnice',
    '3205043': u'Płoty',
    '3205072': u'Rewal',
    '3205083': u'Trzebiatów',
    '3206012': u'Banie',
    '3206023': u'Cedynia',
    '3206033': u'Chojna',
    '3206043': u'Gryfino',
    '3206053': u'Mieszkowice',
    '3206063': u'Moryń',
    '3206072': u'Stare Czarnowo',
    '3206083': u'Trzcińsko-Zdrój',
    '3206092': u'Widuchowa',
    '3207013': u'Dziwnów',
    '3207023': u'Golczewo',
    '3207033': u'Kamień Pomorski',
    '3207043': u'Międzyzdroje',
    '3207052': u'Świerzno',
    '3207063': u'Wolin',
    '3208011': u'Kołobrzeg',
    '3208022': u'Dygowo',
    '3208032': u'Gościno',
    '3208042': u'Kołobrzeg',
    '3208052': u'Rymań',
    '3208062': u'Siemyśl',
    '3208072': u'Ustronie Morskie',
    '3209012': u'Będzino',
    '3209022': u'Biesiekierz',
    '3209033': u'Bobolice',
    '3209042': u'Manowo',
    '3209052': u'Mielno',
    '3209063': u'Polanów',
    '3209073': u'Sianów',
    '3209082': u'Świeszyno',
    '3210013': u'Barlinek',
    '3210022': u'Boleszkowice',
    '3210033': u'Dębno',
    '3210043': u'Myślibórz',
    '3210052': u'Nowogródek Pomorski',
    '3211012': u'Dobra (Szczecińska)',
    '3211022': u'Kołbaskowo',
    '3211033': u'Nowe Warpno',
    '3211043': u'Police',
    '3212012': u'Bielice',
    '3212022': u'Kozielice',
    '3212033': u'Lipiany',
    '3212042': u'Przelewice',
    '3212053': u'Pyrzyce',
    '3212062': u'Warnice',
    '3213011': u'Darłowo',
    '3213021': u'Sławno',
    '3213032': u'Darłowo',
    '3213042': u'Malechowo',
    '3213052': u'Postomino',
    '3213062': u'Sławno',
    '3214011': u'Stargard Szczeciński',
    '3214023': u'Chociwel',
    '3214033': u'Dobrzany',
    '3214042': u'Dolice',
    '3214053': u'Ińsko',
    '3214062': u'Kobylanka',
    '3214082': u'Marianowo',
    '3214092': u'Stara Dąbrowa',
    '3214102': u'Stargard Szczeciński',
    '3214113': u'Suchań',
    '3215011': u'Szczecinek',
    '3215023': u'Barwice',
    '3215033': u'Biały Bór',
    '3215043': u'Borne Sulinowo',
    '3215052': u'Grzmiąca',
    '3215062': u'Szczecinek',
    '3216011': u'Świdwin',
    '3216022': u'Brzeżno',
    '3216033': u'Połczyn-Zdrój',
    '3216042': u'Rąbino',
    '3216052': u'Sławoborze',
    '3216062': u'Świdwin',
    '3217011': u'Wałcz',
    '3217023': u'Człopa',
    '3217033': u'Mirosławiec',
    '3217043': u'Tuczno',
    '3217052': u'Wałcz',
    '3218013': u'Dobra',
    '3218023': u'Łobez',
    '3218032': u'Radowo Małe',
    '3218043': u'Resko',
    '3218053': u'Węgorzyno',
    '3261011': u'Koszalin',
    '3262011': u'Szczecin',
    '3263011': u'Świnoujście',
}
