from django.contrib.sitemaps import Sitemap
from foo.models import Entry


class FooSitemap(Sitemap):
    changefreq = 'daily'
    priority = 0.5

    def items(self):
	return Entry.objects.order_by('-pub_date')

    def lastmod(self, obj):
	return obj.pub_date

    def location(self, obj):
	return obj.get_absolute_url()
