from django.core.management import setup_environ
import settings
setup_environ(settings)

from django.utils.datastructures import SortedDict
from django.contrib.auth.models import User

# pre-condition: a user (root) must exist and two user with id=1 and id=2 must exist

# ensure the order of the extra select-statements stays aligned with the select_params
for result in User.objects.extra(select=
        {'foo3': "SELECT COUNT(auth_user.id) FROM auth_user WHERE (auth_user.username = %s)"}
        , select_params=['root']).extra(select=
        {'foo2': "SELECT COUNT(auth_user.id) FROM auth_user WHERE (auth_user.id = %s)"}
        , select_params=['1']):
    print result.foo3
for result in User.objects.extra(select=
        {'foo1': "SELECT COUNT(auth_user.id) FROM auth_user WHERE (auth_user.username = %s)"}
        , select_params=['root']).extra(select=
        {'foo2': "SELECT COUNT(auth_user.id) FROM auth_user WHERE (auth_user.id = %s)"}
        , select_params=['1']):
    print result.foo1

print User.objects.extra(select=
        {'foo1': "SELECT COUNT(auth_user.id) FROM auth_user WHERE (auth_user.username = %s)"}
        , select_params=['root']).extra(select=
        {'foo2': "SELECT COUNT(auth_user.id) FROM auth_user WHERE (auth_user.id = %s)"}
        , select_params=['2']).filter(id=1).values_list('id')

# test removing extra select-statements:

# using a SortedDict
print User.objects.extra(select=SortedDict((
        ('roo', "SELECT (auth_user.id) FROM auth_user WHERE (auth_user.username = %s)"),
        ('id1', "SELECT (auth_user.id) FROM auth_user WHERE (auth_user.id = %s)"),
        ('id2', "SELECT (auth_user.id) FROM auth_user WHERE (auth_user.id = %s)")
        ))
        , select_params=['roo', 1, '2']).values_list('id2',flat=True)
print User.objects.extra(select=SortedDict((
        ('roo', "SELECT (auth_user.id) FROM auth_user WHERE (auth_user.username = %s)"),
        ('id1', "SELECT (auth_user.id) FROM auth_user WHERE (auth_user.id = %s)"),
        ('id2', "SELECT (auth_user.id) FROM auth_user WHERE (auth_user.id = %s)")
        ))
        , select_params=['roo', 1, '2']).values('roo')

# using chained extra statements, with different selects removed
print User.objects.extra(select=
        {'roo': "SELECT (auth_user.id) FROM auth_user WHERE (auth_user.username = %s)"}
        , select_params=['root']).extra(select=
        {'id1': "SELECT (auth_user.id) FROM auth_user WHERE (auth_user.id = %s)"}
        , select_params=['1']).extra(select=
        {'id2': "SELECT (auth_user.id) FROM auth_user WHERE (auth_user.id = %s)"}
        , select_params=['2']).values('id2')
        
print User.objects.extra(select=
        {'roo': "SELECT (auth_user.id) FROM auth_user WHERE (auth_user.username = %s)"}
        , select_params=['root']).extra(select=
        {'id1': "SELECT (auth_user.id) FROM auth_user WHERE (auth_user.id = %s)"}
        , select_params=['1']).extra(select=
        {'id2': "SELECT (auth_user.id) FROM auth_user WHERE (auth_user.id = %s)"}
        , select_params=['2']).values_list('id1',flat=True)


print User.objects.extra(select=
        {'roo': "SELECT (auth_user.id) FROM auth_user WHERE (auth_user.username = %s)"}
        , select_params=['root']).extra(select=
        {'id1': "SELECT (auth_user.id) FROM auth_user WHERE (auth_user.id = %s)"}
        , select_params=['1']).extra(select=
        {'id2': "SELECT (auth_user.id) FROM auth_user WHERE (auth_user.id = %s)"}
        , select_params=['2']).values_list('roo',flat=True)