from django import template
from django.db.models import get_model

import pdb

register = template.Library()

class ColumnObject:
    pass

@register.inclusion_tag('eadmin/templatetags/results.html', takes_context = True)
def data( context, item ):
    #Cols contains all the fields of the model to be shown
    cols = []
    ld = context['col_attrs']
    field_names = [ field.name for field in item._meta.fields ]
    for d in ld:
        #For each column, check if there is an attribute, a callable function or process a dictionary
        value = None
        co = ColumnObject()
        attr = getattr( item, d )
        #pdb.set_trace()
        #1.-Is it a field?
        if d in field_names:
            field = item._meta.get_field( d )
            if field.get_internal_type() == 'ImageField':
                co.image = getattr( item, 'get_%s_url' % ( 'foto' ) )
            value = attr
        else:
            ##2.-Is it a callable function?
            if callable( attr ):
                value = attr()

        if value:
            co.value = value
            cols.append( co )

    return { 'cols':cols }


@register.inclusion_tag('eadmin/templatetags/tree.html', takes_context = True)
def tree( context, app , parent, parent_id ):

    def get_tree ( app, parent, parent_id ):
        model = get_model( app, parent )
        parent_item = model.objects.get( id = parent_id )
        tree = [ [ parent, ] ]

        if model.__dict__.has_key('eAdmin'):
            eadmin = model.eAdmin()

            if getattr(eadmin,'origin_breadcrumb',None):
                if eadmin.origin_breadcrumb == True:
                    return tree

        for field in model._meta.fields:
            if field.get_internal_type() == 'ForeignKey':
                new_parent = getattr( parent_item, field.name)
                sub_tree = get_tree( app, new_parent._meta.module_name, new_parent.id )
                if sub_tree:
                    tree[-1].extend( [ new_parent.id, new_parent._meta.module_name] )
                    tree.extend( sub_tree )
                    return tree
        return []

    if parent:
        tree = get_tree( app, parent, parent_id )
        if tree:
            tree.reverse()
            return {'found': True, 'tree': tree, 'app': app }
        else:
            return {'found': False }
    else:
        return {}


@register.inclusion_tag('eadmin/templatetags/render_form.html', takes_context = True)
def render_form( context, form, item ):
    from django import newforms as forms
    from eadmin.forms.widgets import AdminDateWidget,ImageWidget

    for field_name,field_instance in form.fields.iteritems():
        if isinstance( field_instance, forms.DateField ):
            field_instance.widget = AdminDateWidget()
            #pdb.set_trace()
        elif isinstance( field_instance, forms.ImageField ):
            field_instance.widget = ImageWidget()

    return {'form':form,
            'item':item,
            }


