from django.db import models

class Vocabulary(models.Model):
    root = models.ForeignKey('Term', null=True, blank=True, related_name='root_of')

    def save(self):
        """When a vocabulary is saved and it has no root term, a new root
        term is created. This happens only the first time a vocabulary is
        saved.
        """
        super(Vocabulary, self).save()
        
        if not self.root:            
            self.root = Term.objects.create(vocabulary=self)
            super(Vocabulary, self).save()

class Term(models.Model):
    vocabulary = models.ForeignKey(Vocabulary)

    def save(self):
         super(Term, self).save()

         # As soon as self.parent is referenced here, the unittest fails.
         # It does not matter if the self.parent is printed, used or changed.
         # Any of the following will make the unittest fail!
         #print "term.vocabulary:", self.vocabulary
         self.vocabulary
    