from django.db import models

class Employee(models.Model):
    name = models.CharField(max_length=100)
    salary = models.IntegerField()
    birth_date = models.DateField()

__test__ = {'API_TEST': '''
>>> from datetime import date
>>> from django.db.models import F
>>> a = Employee(name='Alex', salary=130, birth_date=date(1980, 1, 8))
>>> a.save()
>>> b = Employee(name='Brian', salary=150, birth_date=date(1970, 3, 4))
>>> b.save()
>>> c = Employee(name='Michael', salary=100, birth_date=date(1960, 5, 6))
>>> c.save()
>>> Employee.objects.all().update(salary=F('salary')+20)
>>> print Employee.objects.get(pk=a.pk).salary
150
>>> print Employee.objects.get(pk=b.pk).salary
170
>>> Employee.objects.all(salary=F('salary')*1.1)
>>> print Employee.objects.get(pk=a.pk).salary
165
>>> print Employee.objects.get(pk=b.pk).salary
187
>>> Employee.objects.filter(salary__gt=170).update(name=F('salary'))
>>> print Employee.objects.get(pk=b.pk).name
187
'''
}