Index: paginator.py
===================================================================
--- paginator.py	(revision 1066)
+++ paginator.py	(working copy)
@@ -56,6 +56,29 @@
 
     def has_previous_page(self, page_number):
         return page_number > 0
+    
+    def first_on_page(self, page_number):
+        "Returns the # of the first object on the current page relative to total objects found (hits)."
+        if page_number == 0:
+            return page_number + 1
+        else:
+            return (self.num_per_page * page_number) + 1
+    
+    def last_on_page(self, page_number):
+        "Returns the # of the last object on the current page relative to total objects found (hits)."
+        hits_,pages_ = self.hits,self.pages
+        if page_number == 0: #first page
+            if self.num_per_page >= hits_:
+                return hits_
+            else:
+                return self.num_per_page
+        elif page_number == (pages_ - 1): # last page is (pages - 1) because the paginator is zero-indexed
+            if ((page_number + 1) * self.num_per_page) > hits_:
+                return hits_
+            else:
+                return ((page_number + 1) * self.num_per_page)
+        else: # pages between first and last
+            return ((page_number + 1) * self.num_per_page)
 
     def _get_hits(self):
         if self._hits is None:
