# Django settings for rvucms project.
import logging


#----------------------------------------------------------------------------------------------#
# Below are the settings that most likely change per environment                               #
#----------------------------------------------------------------------------------------------#

#DEBUG needs to be 'False' on environments other than development
# NOTE: with DEBUG = True, some settings are overridden ot the bottom of this file.
DEBUG = True
TEMPLATE_DEBUG = DEBUG

# logging configuratie
LOG_LEVEL = logging.WARN
LOG_FILE = '/var/log/rvucms/rvucms.log'

DATABASE_ENGINE = 'mysql'           # 'postgresql_psycopg2', 'postgresql', 'mysql', 'sqlite3' or 'ado_mssql'.
DATABASE_NAME = 'rvu-cms'             # Or path to database file if using sqlite3.
DATABASE_USER = 'rvu-cms'             # Not used with sqlite3.
DATABASE_PASSWORD = 'rvu-cms'         # Not used with sqlite3.
DATABASE_HOST = ''             # Set to empty string for localhost. Not used with sqlite3.
DATABASE_PORT = ''             # Set to empty string for default. Not used with sqlite3.

# location of the cache. Needs to be an absolute path
CACHE_BACKEND = 'file:///tmp/django_cache'

# Absolute path to the directory that holds media.
# Example: "/home/media/media.lawrence.com/"
MEDIA_ROOT = '/var/data/work/rvucms-media/'

TEMPLATE_DIRS = (
    # Put strings here, like "/home/html/django_templates" or "C:/www/django/templates".
    # Always use forward slashes, even on Windows.
    # Don't forget to use absolute paths, not relative paths.
    "/home/schraal/hippe-it/projects/rvucms/cms/templates",
)

#----------------------------------------------------------------------------------------------#
# DO NOT CHANGE THE SETTINGS BELOW HERE, UNLESS YOU KNOW WHAT YOU'RE DOING                     #
#----------------------------------------------------------------------------------------------#

CACHE_MIDDLEWARE_SECONDS = 300
CACHE_MIDDLEWARE_KEY_PREFIX = 'rvucms'
CACHE_MIDDLEWARE_ANONYMOUS_ONLY = True

ADMINS = (
    # ('Your Name', 'your_email@domain.com'),
)

MANAGERS = ADMINS

# Local time zone for this installation. Choices can be found here:
# http://www.postgresql.org/docs/8.1/static/datetime-keywords.html#DATETIME-TIMEZONE-SET-TABLE
# although not all variations may be possible on all operating systems.
# If running in a Windows environment this must be set to the same as your
# system time zone.
TIME_ZONE = 'Europe/Amsterdam'

# Language code for this installation. All choices can be found here:
# http://www.w3.org/TR/REC-html40/struct/dirlang.html#langcodes
# http://blogs.law.harvard.edu/tech/stories/storyReader$15
LANGUAGE_CODE = 'nl-nl'

DATETIME_FORMAT = 'd-m-Y H:i'

# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = True

APPEND_SLASH = True

# URL that handles the media served from MEDIA_ROOT.
# Example: "http://media.lawrence.com"
MEDIA_URL = ''

# URL prefix for admin media -- CSS, JavaScript and images. Make sure to use a
# trailing slash.
# Examples: "http://foo.com/media/", "/media/".
ADMIN_MEDIA_PREFIX = '/media/'

# Make this unique, and don't share it with anybody.
SECRET_KEY = 'iu720@5n*ax^=z@d(5w+m)kpcjffne(pvb+#6w2s_pz*5)b%$f'

# List of callables that know how to import templates from various sources.
TEMPLATE_LOADERS = (
    'django.template.loaders.filesystem.load_template_source',
    'django.template.loaders.app_directories.load_template_source',
#     'django.template.loaders.eggs.load_template_source',
)

TEMPLATE_CONTEXT_PROCESSORS = (
    'django.core.context_processors.auth',
    'django.core.context_processors.debug',
    'django.core.context_processors.i18n',
)

MIDDLEWARE_CLASSES = (
    'django.middleware.common.CommonMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.middleware.doc.XViewMiddleware',
    'django.middleware.cache.CacheMiddleware',
)

ROOT_URLCONF = 'rvucms.urls'

INSTALLED_APPS = (
    'rvucms.cms',
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'rvucms.upload'
)

## override some properties for development.
if DEBUG:
    LOG_LEVEL = logging.DEBUG
    LOG_FILE = '/tmp/rvucms.log'

    DATABASE_ENGINE = 'mysql'           # 'postgresql_psycopg2', 'postgresql', 'mysql', 'sqlite3' or 'ado_mssql'.
    DATABASE_NAME = 'rvu-cms'             # Or path to database file if using sqlite3.
    DATABASE_USER = 'rvu-cms'             # Not used with sqlite3.
    DATABASE_PASSWORD = 'rvu-cms'         # Not used with sqlite3.
    DATABASE_HOST = ''             # Set to empty string for localhost. Not used with sqlite3.
    DATABASE_PORT = ''             # Set to empty string for default. Not used with sqlite3.

    CACHE_BACKEND = 'file:///tmp/django_cache'
    CACHE_MIDDLEWARE_SECONDS = 0

    # Absolute path to the directory that holds media.
    # Example: "/home/media/media.lawrence.com/"
    MEDIA_ROOT = '/var/data/work/rvucms-media/'

    TEMPLATE_DIRS = (
        # Put strings here, like "/home/html/django_templates" or "C:/www/django/templates".
        # Always use forward slashes, even on Windows.
        # Don't forget to use absolute paths, not relative paths.
        "/home/schraal/hippe-it/projects/rvucms/cms/templates",
    )

logging.basicConfig(level=LOG_LEVEL,
                format='%(asctime)s %(levelname)s %(message)s',
                filename=LOG_FILE,
                filemode='w')
