from django.core import management

# This dictionary maps Field objects to their associated MySQL column
# types, as strings. Column-type strings can contain format strings; they'll
# be interpolated against the values of Field.__dict__ before being output.
# If a column type is set to None, it won't be included in the output.
# TODO: %(attname)s or %(column)s can't be used when column name is truncated 
#       due dbengine name length limit. db_column is None. What to do?
DATA_TYPES = {
    'AutoField':         'integer generated by default as identity (start with 1, increment by 1)',
    'BooleanField':      'decimal(1,0) CHECK (%(attname)s IN (0,1))', # TODO: upper/lower don't match
    'CharField':         'varchar(%(max_length)s)',
    'CommaSeparatedIntegerField': 'varchar(%(max_length)s)',
    'DateField':         'date',
    'DateTimeField':     'timestamp', # has miliseconds too
    'DecimalField':      'decimal(%(max_digits)s, %(decimal_places)s)',
    'FileField':         'varchar(100)',
    'FilePathField':     'varchar(100)',
    'FloatField':        'float',
    'ImageField':        'varchar(100)',
    'IntegerField':      'integer',
    'IPAddressField':    'char(15)',
    'NullBooleanField':  'decimal(1,0) CHECK (%(attname)s IN (0,1) OR (%(attname)s IS NULL))', # TODO: quoted manually
    'OneToOneField':     'integer',
    'PhoneNumberField':  'varchar(20)',
    'PositiveIntegerField': 'integer CHECK (%(column)s >= 0)', 
    'PositiveSmallIntegerField': 'smallint CHECK (%(column)s >= 0)', 
    'SlugField':         'varchar(%(max_length)s)',
    'SmallIntegerField': 'smallint',
    # NOTE: <32600 varchar(), else CLOB (%(length)s K/M/G) kilo, mega, giga, >1g should be not logged
    #'TextField':         'varchar%(max_length)s', # can't go if max_length is None, and long varchar can't be part of unique idx/primary key
    'TextField':         '%(varchar_spec_db2)s', # max 32700, clob can't be used since can't be part of index (permission.username)
    'TimeField':         'time',
    'USStateField':      'char(2)',
    }

def create_test_db(settings, connection, verbosity=1, autoclobber=False):
    """ pydb2 can't issue create db commands """
    
    # assert settings.TEST_DATABASE_NAME
    # assert settings.TEST_DATABASE_USER      
    # assert settings.TEST_DATABASE_PASSWD
    # #TEST_DATABASE_TBLSPACE = _test_database_tblspace(settings)
    # #TEST_DATABASE_TBLSPACE_TMP = _test_database_tblspace_tmp(settings)
    # 
    # print 101, settings.TEST_DATABASE_NAME, settings.DATABASE_NAME
    # 
    # settings.DATABASE_NAME     = settings.TEST_DATABASE_NAME
    # settings.DATABASE_USER     = settings.TEST_DATABASE_USER
    # settings.DATABASE_PASSWORD = settings.TEST_DATABASE_PASSWD

    print 102, settings.DATABASE_NAME #, settings.TEST_DATABASE_NAME

    cursor = connection.cursor()
    
    connection.close()

    management.call_command('syncdb', verbosity=verbosity, interactive=False)

    # Get a cursor (even though we don't need one yet). This has
    # the side effect of initializing the test database.
    cursor = connection.cursor()
    
    return settings.TEST_DATABASE_NAME
    
def destroy_test_db(settings, connection, old_database_name, verbosity=1):
    """ no create no drop """
    cursor = connection.cursor()
    #time.sleep(1) # To avoid "database is being accessed by other users" errors.
    connection.close()
