from django.db.backends.db2.base import DatabaseOperations
from DB2 import ProgrammingError, OperationalError

# NOTE: list from pydb2::_db2_module.c and values from db2 install programfiles\sqllib\include\sqlcli.h 
# TODO: In pydb2::_db2_module.c defined but not in DB2.py (btw. this is copy from general\sql.py)
DB2_SQL_CHAR             = 1     # , "CHAR"            
DB2_SQL_NUMERIC          = 2     # , "NUMERIC"         
DB2_SQL_DECIMAL          = 3     # , "DECIMAL"         
DB2_SQL_INTEGER          = 4     # , "INTEGER"         
DB2_SQL_SMALLINT         = 5     # , "SMALLINT"        
DB2_SQL_FLOAT            = 6     # , "FLOAT"           
DB2_SQL_REAL             = 7     # , "REAL"            
DB2_SQL_DOUBLE           = 8     # , "DOUBLE"          
DB2_SQL_VARCHAR          = 12    # , "VARCHAR"         
DB2_SQL_LONGVARCHAR      = -1    # , "LONGVARCHAR"     
DB2_SQL_BINARY           = -2    # , "BINARY" 
DB2_SQL_VARBINARY        = -3    # , "VARBINARY"       
DB2_SQL_LONGVARBINARY    = -4    # , "LONGVARBINARY"   
DB2_SQL_BIGINT           = -5    # , "BIGINT"          
DB2_SQL_GRAPHIC          = -95   # ,"GRAPHIC"          
DB2_SQL_VARGRAPHIC       = -96   # ,"VARGRAPHIC"       
DB2_SQL_LONGVARGRAPHIC   = -97   # ,"LONGVARGRAPHIC"   
DB2_SQL_BLOB             = -98   # ,"BLOB"             
DB2_SQL_CLOB             = -99   # ,"CLOB"             
DB2_SQL_DBCLOB           = -350  # ,"DBCLOB"           
DB2_SQL_DATALINK         = -400  # ,"DATALINK"         
DB2_SQL_BLOB_LOCATOR     =  31   # ,"BLOB_LOCATOR"     
DB2_SQL_CLOB_LOCATOR     =  41   # ,"CLOB_LOCATOR"     
DB2_SQL_TYPE_DATE        =  91   # ,"DATE"             
DB2_SQL_DBCLOB_LOCATOR   =  -351 # ,"DBCLOB_LOCATOR"   
DB2_SQL_TYPE_TIME        =  92   # ,"TIME"             
DB2_SQL_TYPE_TIMESTAMP   =  93   # ,"TIMESTAMP"        


quote_name = DatabaseOperations().quote_name

def get_table_list(cursor):
    "Returns a list of table names in the current database."
    cursor.execute("select TABNAME from syscat.tables where type='T' and tabschema=current schema")
    return [row[0] for row in cursor.fetchall()]

# NOTE: other way is to look in catalog:        
#     sql_colnames=(  "colname"       #
#                   , "keyseq"        # ZA PRIMARNI KLJUC - !=0 1,2,3, ...
#                   , "typename"      #
#                   , "nulls"         #
#                   , "length"        #
#                   , "scale"         #
#                   , "default"       # [with] DEFAULT VALUE, what with sequences??
#                   , "identity"      # Y/N
#                   , "generated"     # ' '/
#                   , "codepage"      # for char* fields
#                   , "logged"        # for *lob data - default is logged     
#                   , "compact"       # for *lob data - default is not compact
#                   , "remarks"       # comments                              
#                   )
#     sqlcmd = ("select %s from syscat.columns where tabschema=current schema and tabname='%s' ORDER BY COLNO"
#                % ( ",".join(sql_colnames), table_name))
def get_table_description(cursor, table_name):
    "Returns a description of the table, with the DB-API cursor.description interface."
    cursor.execute("SELECT * FROM %s FETCH FIRST 1 ROWS ONLY" % quote_name(table_name))
    return cursor.description

# mysql/oracle have this
def _name_to_index(cursor, table_name):
    """
    Returns a dictionary of {field_name: field_index} for the given table.
    Indexes are 0-based.
    """
    return dict([(d[0], i) for i, d in enumerate(get_table_description(cursor, table_name))])


def get_relations(cursor, table_name):
    """
    Returns a dictionary of {field_index: (field_index_other_table, other_table)}
    representing all relationships to the given table. Indexes are 0-based.
    """
    my_field_dict = _name_to_index(cursor, table_name)
    constraints = []
    relations = {}
    
    #SELECT column_name, referenced_table_name, referenced_column_name
    #, DELETERULE, UPDATERULE, REFKEYNAME, DEFINER
    # TODO: check if upper() is needed 
    cursor.execute("""
                   SELECT CONSTNAME
                       , FK_COLNAMES
                       , REFTABSCHEMA
                       , REFTABNAME
                       , PK_COLNAMES
                       , COLCOUNT
                   FROM SYSCAT.REFERENCES 
                   WHERE 1=1
                   AND TABNAME='%s'
                   AND TABSCHEMA=current schema 
                   """ % (table_name,))
    #print sql
    for row in cursor.fetchall():
        pos = 0
        (cons_name, local_columns, remote_schema, remote_table, remote_columns, colcount) = row
        local_columns  = local_columns.strip().split(" ") 
        local_columns = [col for col in local_columns if col]
        
        remote_columns = remote_columns.strip().split(" ")   
        remote_columns = [col for col in remote_columns if col]           
        
        assert colcount==len(local_columns)==len(remote_columns)
        assert colcount>0
        
        other_table = remote_table
        for my_fieldname, other_field in zip(local_columns, remote_columns):
            #{field_index: (field_index_other_table, other_table)}
            other_field_index = _name_to_index(cursor, other_table)[other_field]
            my_field_index = my_field_dict[my_fieldname]
            relations[my_field_index] = (other_field_index, other_table)

    return relations


def get_indexes(cursor, table_name):
    """
    Returns a dictionary of fieldname -> infodict for the given table,
    where each infodict is in the format:
        {'primary_key': boolean representing whether it's the primary key,
         'unique': boolean representing whether it's a unique index}
    """
    # substr(rtrim(indSCHEMA) || '.' ||rtrim(a.indNAME),1,30) ind
   	# substr(rtrim(tabSCHEMA) || '.' ||rtrim(tabNAME),1,30) tab
   	# substr(indSCHEMA,1,8) indschema
   	# SUBSTR(indNAME,1,16) indNAME 
    # IND                            U TAB                            COLNAMES                       INDSCHEMA INDNAME         
    # ------------------------------ - ------------------------------ ------------------------------ --------- ----------------
    # DBA.D01I010_PRIM               P DBA.D01T010                    +FOLDERCD+CTBNAME+CTBWERT+CTBS DBA       D01I010_PRIM    

    cursor.execute("""
                   select 
                   	    uniquerule
                   	  , colnames
                   	  , indname
                   from syscat.indexes 
                   where 1=1
                        and tabschema=current schema 
                        and tabname='%s'
                   """ % table_name)
    indexes = {}
    for row in cursor.fetchall():
        uniquerule, colnames, indname = row
        cols = [col for col in colnames.split("+") if col.strip()!=""]
        for col in cols:
            # TODO: Is this logic what django expects?
            #                    for persid:  P    U 
            # p persid+versgbeg               T    F
            # p persid                        T    T
            # u persid+versgbeg               F    F
            # u persid                        F    T
            primary = (uniquerule=='P')
            unique = (len(cols)==1 and (primary or uniquerule=='U'))
            #if col=="PERSNR":
            #    print col, len(cols)==1, uniquerule, primary, unique
            colname = col.strip()
            # TODO: solve this in django!
            if indexes.has_key(colname):
                raise NotImplementedError("Case not considered in Django: table %s colname %s in several indexes - last idx %s" % (table_name, colname, indname))
            indexes[colname] = {'primary_key': primary, 'unique': unique}
    return indexes


DATA_TYPES_REVERSE = {
      DB2_SQL_CHAR             : "CharField"
    , DB2_SQL_NUMERIC          : "DecimalField"       
    , DB2_SQL_DECIMAL          : "DecimalField"       
    , DB2_SQL_INTEGER          : "IntegerField"       
    , DB2_SQL_SMALLINT         : "SmallIntegerField"      
    , DB2_SQL_FLOAT            : "FloatField"         
    , DB2_SQL_REAL             : "FloatField"          
    , DB2_SQL_DOUBLE           : "FloatField"        
    , DB2_SQL_VARCHAR          : "TextField"       
    , DB2_SQL_LONGVARCHAR      : "TextField"   
    , DB2_SQL_BINARY           : "TextField"        # TODO: ok?
    , DB2_SQL_VARBINARY        : "TextField"     
    , DB2_SQL_LONGVARBINARY    : "TextField" 
    , DB2_SQL_BIGINT           : "IntegerField"        
    , DB2_SQL_GRAPHIC          : "TextField"       
    , DB2_SQL_VARGRAPHIC       : "TextField"    
    , DB2_SQL_LONGVARGRAPHIC   : "TextField"
    , DB2_SQL_BLOB             : "TextField"          
    , DB2_SQL_CLOB             : "TextField"          
    , DB2_SQL_DBCLOB           : "TextField"        
    #, DB2_SQL_DATALINK         : "DatalinkField"      # ??
    #, DB2_SQL_BLOB_LOCATOR     : "BlobField"          
    #, DB2_SQL_CLOB_LOCATOR     : "ClobField"          
    #, DB2_SQL_DBCLOB_LOCATOR   : "DbclobField"        
    , DB2_SQL_TYPE_DATE        : "DateField"          
    , DB2_SQL_TYPE_TIME        : "TimeField"          
    , DB2_SQL_TYPE_TIMESTAMP   : "DatetimeField"     
}
