import os

# db2 7.2 default settings - 
# db2 => list command options
# 
#      Command Line Processor Option Settings
# 
#  Backend process wait time (seconds)        (DB2BQTIME) = 1
#  No. of retries to connect to backend        (DB2BQTRY) = 60
#  Request queue wait time (seconds)          (DB2RQTIME) = 5
#  Input queue wait time (seconds)            (DB2IQTIME) = 5
#  Command options                           (DB2OPTIONS) =
# 
#  Option  Description                               Current Setting
#  ------  ----------------------------------------  ---------------
#    -a    Display SQLCA                             OFF
#    -c    Auto-Commit                               ON
#    -e    Display SQLCODE/SQLSTATE                  OFF
#    -f    Read from input file                      OFF
#    -l    Log commands in history file              OFF
#    -n    Remove new line character                 OFF
#    -o    Display output                            ON
#    -p    Display interactive input prompt          ON
#    -r    Save output to report file                OFF
#    -s    Stop execution on command error           OFF
#    -t    Set statement termination character       OFF
#    -v    Echo current command                      OFF
#    -w    Display FETCH/SELECT warning messages     ON
#    -x    Suppress printing of column headings      OFF
#    -z    Save all output to output file            OFF

def runshell():
    args = [
           #'-c-' # NOTE: autocommit is true, switch it off by providing args "-c-"
           ]
    from django.conf import settings
    dsn = settings.DATABASE_NAME
    usr = settings.DATABASE_USER
    pwd = settings.DATABASE_PASSWORD
    
    # TODO: This doesn't work properly, db2 needs 2 commands and db2 env propmpt to be initialized
    # for db2.exe to work the env should be set by calling: db2 command line processor e.g.
    #    C:\Programme\SQLLIB\bin\db2cmd.exe DB2CLP.BAT DB2.EXE
    # in other case you get:
    #    C:\>db2
    #    DB21061E  Command line environment not initialized.
    # other way to do it is by calling db2 window (goes directly to prompt):
    #    C:\Programme\SQLLIB\bin\db2cmd.exe DB2CLP.BAT
    os.execvp("db2",  ["db2 connect to %s user %s using %s" % (dsn, usr, pwd),])
    os.execvp('db2', args)

# if __name__=="__main__":
#    runshell()