"""
DB2 database backend for Django.
created: ulr1 071018/uvi1 071018 
   
Requires PyDB2: http://sourceforge.net/projects/pydb2

reference for create table:
   file:///C|/Programme/SQLLIB/doc/html/db2s0/frame3.htm#index
"""

# TODO: PYDB2 date/time/datetime column values or in params are returned as strings and not datetime.* objects
# TODO: PYDB2 fetchall - make iterator from it
from django.db.backends import BaseDatabaseWrapper, BaseDatabaseFeatures, BaseDatabaseOperations, util
try:
    import DB2 as Database
    Database.paramstyle="format"
    # Debugging purposes
    Database.echo=True
except ImportError, e:
    from django.core.exceptions import ImproperlyConfigured
    raise ImproperlyConfigured("Error loading DB2 module: %s" % e)

# version = Database.version_info
# _db2_module self->dbmsVer
# if (version < (1,2,1) or (version[:3] == (1, 2, 1) and
#         (len(version) < 5 or version[3] != 'final' or version[4] < 2))):
#     raise ImportError("DB2-1.2.1p2 or newer is required; you have %s" % Database.__version__)

import types
import re

DatabaseError = Database.DatabaseError
IntegrityError = Database.IntegrityError

# TODO: db2 boolean, db2 datetime ...

class DatabaseFeatures(BaseDatabaseFeatures):
    #db2 selection:
    supports_tablespaces = True
    # #mysql
    # autoindexes_primary_keys = False
    # #oracle
    # allows_group_by_ordinal = False
    # allows_unique_and_pk = False        # Suppress UNIQUE/PK for Oracle (ORA-02259)
    # needs_datetime_string_cast = False
    # needs_upper_for_iops = True
    # supports_tablespaces = True
    uses_case_insensitive_names = True
    # uses_custom_queryset = True
    # #postgres
    # pass # This backend uses all the defaults.
    # #postgres2
    # needs_datetime_string_cast = False
    # #sqlite3
    # supports_constraints = False
    # #mssql
    # supports_tablespaces = True


class DatabaseOperations(BaseDatabaseOperations):
   
    # TODO: db2 supports sequencess and autoinc columns too, for now only oracle needs some extra work, but as trigger
    #       maybe db2 will need this too
    # def autoinc_sql(self, table):
    # colspec += " GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1)"

    # TODO: oracle/postgres, db2 doesn't have solved here for now
    # def sequence_reset_sql(self, style, model_list):


    # values(current timestamp, date(current timestamp));
    # -------------------------- ----------
    # 2007-10-18-15.07.52.115000 2007-10-18
    def date_extract_sql(self, lookup_type, field_name):
        # http://dev.mysql.com/doc/mysql/en/date-and-time-functions.html
        return "DATE(%S)" % (field_name)

    # copied frunction from mssql
    # TODO: IMPLEMENT ....
    def date_trunc_sql(self, lookup_type, field_name):
        if lookup_type == 'year':
            return "Convert(datetime, Convert(varchar, DATEPART(year, %s)) + '/01/01')" % field_name
        if lookup_type == 'month':
            return "Convert(datetime, Convert(varchar, DATEPART(year, %s)) + '/' + Convert(varchar, DATEPART(month, %s)) + '/01')" % (field_name, field_name)
        if lookup_type == 'day':
            return "Convert(datetime, Convert(varchar(12), %s))" % field_name
        raise NotImplementedError("date_trunc_sql(lookup_type=%s)" % lookup_type)

    # db2 doesn't have this
    #def deferrable_sql(self):
    #    # other have - this is related to constraints: 
    #    return " DEFERRABLE INITIALLY DEFERRED"
    #    # db2 only similar option is when creating table - for mqt e.g. 
    #    # return " DATA INITIALLY DEFERRED"

    def last_insert_id(self, cursor, table_name, pk_name):
        #sq_name = util.truncate_name(table_name, self.max_name_length() - 3)
        #cursor.execute('SELECT %s_sq.currval FROM dual' % sq_name)
        cursor.execute('VALUES identity_val_local()')
        #if last_id is not None:
        #    last_id = int(last_id)
        return cursor.fetchone()[0]

    def quote_name(self, name, object_type_name=None):
        # TODO: if table is lowercase then: select * from "mfd1_data"; now is: select * from "mfd1_data"
        #       check quote and other
        # fix: logic from oracle 
        # if not name.startswith('"') and not name.endswith('"'):
        name = name.replace("-", "_") # no hyphen in name
        if name in (name.upper(), name.lower()):
            name = '%s' % util.truncate_name(name, self.max_name_length(object_type_name)).upper()
        else:
            name = '"%s"' % util.truncate_name(name, self.max_name_length(object_type_name))
        return name

    # the simpliest from sqlite, probably some constraints and autoincrement should be reset too.
    # TODO: check this. probably can be problem with too-big sql command. we do clear table with import from empty.del file
    def sql_flush(self, style, tables, sequences):
        # NB: The generated SQL below is specific to SQLite
        # Note: The DELETE FROM... SQL generated below works for SQLite databases
        # because constraints don't exist
        sql = ['%s %s %s;' % \
                (style.SQL_KEYWORD('DELETE'),
                 style.SQL_KEYWORD('FROM'),
                 style.SQL_FIELD(self.quote_name(table))
                 ) for table in tables]
        # Note: No requirement for reset of auto-incremented indices (cf. other
        # sql_flush() implementations). Just return SQL at this point
        return sql

    def random_function_sql(self):
        return 'RAND()'

    def tablespace_sql(self, tablespace, inline=False):
        return "IN %s" % self.quote_name(tablespace)

    #sqlite3/mysql
    # def drop_foreignkey_sql(self):

    def limit_offset_sql(self, limit, offset=None):
        if offset:
            raise NotImplementedError("db2 doesn't support OFFSET in sql select stmt (%s)" % offset)
        return "FETCH FIRST " + str(limit) + " ROWS ONLY"


    # sqlite3 specific
    # def pk_default_value(self):
        
    # mysql specific 
    # def fulltext_search_sql(self, field_name):

    # oracle
    # TODO: check if any of these db2 should have
    # def datetime_cast_sql(self):
    #     return "TO_TIMESTAMP(%s, 'YYYY-MM-DD HH24:MI:SS.FF')"
    # 
    # def drop_sequence_sql(self, table):
    #     return "DROP SEQUENCE %s;" % self.quote_name(get_sequence_name(table))
    # 
    # def field_cast_sql(self, db_type):
    #     if db_type and db_type.endswith('LOB'):
    #         return "DBMS_LOB.SUBSTR(%s)"
    #     else:
    #         return "%s"
    #
    
    # in db2 ver 9 
    def max_name_length(self, object_type_name=None):
       # for db2 7.2
       if object_type_name is None:
          return 30
       elif object_type_name=="table":
          return 128
       elif object_type_name=="column":
          return 30
       elif object_type_name in ("index", "constraint"):
          #(db2 ver 9 - this is expanded to 128)
          return 18
       else:
          raise ValueError("object_type_name %s not valid" % object_type_name)
          

class DatabaseWrapper(BaseDatabaseWrapper):
    features = DatabaseFeatures()
    ops = DatabaseOperations()

    # TODO: Check this in practice. DB2 joker chars are _ and %
    operators = {
        'exact': '= %s',
        'iexact': "LIKE %s ESCAPE '\\'",
        'contains': "LIKE %s ESCAPE '\\'",
        'icontains': "LIKE %s ESCAPE '\\'",
        #'regex': 'REGEXP %s',
        #'iregex': "REGEXP '(?i)' || %s",
        'gt': '> %s',
        'gte': '>= %s',
        'lt': '< %s',
        'lte': '<= %s',
        'startswith': "LIKE %s ESCAPE '\\'",
        'endswith': "LIKE %s ESCAPE '\\'",
        'istartswith': "LIKE %s ESCAPE '\\'",
        'iendswith': "LIKE %s ESCAPE '\\'",
        }


    # mysql specific
    # def __init__(self, **kwargs):
    # def _rollback(self):

    #oracle/mysql
    def _valid_connection(self):
        return  self.connection is not None
        

    def _cursor(self, settings):
        from warnings import filterwarnings
        if not self._valid_connection():
            kwargs = {
                #'conv': django_conversions,
                
                # TODO: How to configure utf connection
                #'charset': 'utf8',
                #'use_unicode': True,
                
                # TODO: other options for db2 connection:
                #     autoCommit  = 0 # no auto-commit mode 
                #     connectType = 1 # single database per Unit of Work
                #   check SingletonThreadPool at the end of file - there can be threading connect 
                #   option connectType defined in pydb2 (1,2,3,4) - def is 2
                }
            if settings.DATABASE_USER:
                kwargs['uid'] = settings.DATABASE_USER
            if settings.DATABASE_NAME:
                kwargs['dsn'] = settings.DATABASE_NAME
            if settings.DATABASE_PASSWORD:
                kwargs['pwd'] = settings.DATABASE_PASSWORD
            kwargs.update(self.options)
            self.connection = Database.connect(**kwargs)
        cursor = self.connection.cursor()
        # TODO: DO I NEED THIS: 
        # if settings.DEBUG:
        #     # NOTE: What is this for?
        #     filterwarnings("error", category=Database.Warning)
        return cursor

    # mysql
    # FASTFIX:
    def get_server_version(self):
        return (7, 2, 2)

    # sqlite3 
    # def close(self):