
import py
from robustapply import function

def test_function():
    def f():
        pass
    assert function(f) == (f, f.func_code, 0)

def test_method():
    class A:
        def m(self, stuff):
            pass

    obj = A()
    assert function(obj.m) == (obj.m, A.m.im_func.func_code, 1)

def test_method_unbound():
    class A:
        def m(self, stuff):
            pass
    assert function(A.m) == (A.m, A.m.im_func.func_code, 1)

def test_method_newstyle():
    class A(object):
        def m(self, stuff):
            pass

    obj = A()
    assert function(obj.m) == (obj.m, A.m.im_func.func_code, 1)

def test_method_unbound_newstyle():
    class A(object):
        def m(self, stuff):
            pass
    assert function(A.m) == (A.m, A.m.im_func.func_code, 1)

def test_class():
    py.test.skip("Explodes on top of pypy-c")
    class A:
        def __init__(self):
            pass
    py.test.raises(ValueError, function, A)

def test_newstyle_class():
    py.test.skip("Explode on top of pypy-c")
    class A(object):
        def __init__(self):
            pass
    py.test.raises(ValueError, function, A)

def test_class_instance():
    class A:
        def __call__(self):
            pass

    obj = A()
    assert function(obj) == (obj.__call__, obj.__call__.im_func.func_code, 1)

def test_newclass_instance():
    class A(object):
        def __call__(self):
            pass

    obj = A()
    assert function(obj) == (obj.__call__, obj.__call__.im_func.func_code, 1)

def test_static_class_methods():
    class A(object):
        @staticmethod
        def a():
            pass

        @classmethod
        def b(cls):
            pass

    obj = A()
    assert function(obj.a) == (obj.a, obj.a.func_code, 0)
    assert function(obj.b) == (obj.b, obj.b.im_func.func_code, 1)
