from django.db import models

class Job(models.Model):
    
    title = models.CharField(max_length=100)
    reports_to = models.ManyToManyField('self', null=True, blank=True, related_name='reports_to_set', symmetrical=False)
    supervises = models.ManyToManyField('self', null=True, blank=True, related_name='supervises_set', symmetrical=False)

    class Admin:
        pass
        
    def __unicode__(self):
        return self.title