# coding: utf-8
from django.db import models

class Place(models.Model):
    name = models.CharField(max_length=50)
    address = models.CharField(max_length=80)

class Restaurant(Place):
    serves_hot_dogs = models.BooleanField()
    serves_pizza = models.BooleanField()

__test__ = {'API_TESTS': """
# #6755 regression test
>>> r = Restaurant(serves_pizza = False)
>>> r.save()
>>> r.id
1
>>> r.place_ptr_id
1
>>> r = Restaurant(place_ptr_id = 1, serves_pizza = True)
>>> r.save()
>>> r.id
1
>>> r.place_ptr_id
1

"""
}
