from timeit import Timer

TIMES = 20000

from django.utils.text import wrap, new_wrap
from django.contrib.webdesign import lorem_ipsum

def compare(text):
    print 'old:', Timer('wrap(%r, 78)' % text, 'from django.utils.text import wrap').timeit(TIMES)
    print 'new:', Timer('wrap(%r, 78)' % text, 'from django.utils.text import new_wrap as wrap').timeit(TIMES)

print
print 'Sentence'
compare(lorem_ipsum.sentence())

print
print 'Paragraph'
compare(lorem_ipsum.paragraph())

print
print '10 Paragraphs'
compare('\n\n'.join(lorem_ipsum.paragraphs(10, common=False)))