from django.db import models
from decimal import Decimal

class Foo(models.Model):
    """ A test class, to check DecimalField works
    >>> type(Decimal('0.00'))
    <class 'decimal.Decimal'>
    
    This fails, however:
    >>> f = Foo()
    >>> type(f.decimal)
    <class 'decimal.Decimal'>
    
    I get a unicode string instead
    Expected:
        <class 'decimal.Decimal'>
    Got:
        <type 'unicode'>
        
    Workaround: you can save and reload it:
    >>> f.save()
    >>> g = Foo.objects.get(id=f.id)
    >>> type(g.decimal)
    <class 'decimal.Decimal'>
    """
    
    decimal = models.DecimalField(decimal_places=2, max_digits=10, default=Decimal("0.00"))
    
