# -*- coding: utf-8 -*-
"""
A list of all nine provinces in Austria, see also: http://en.wikipedia.org/wiki/ISO_3166-2:AT
In the comments there are their english names, if they are not the same as the german ones.
Vienna is moved to the top, because it's the capital of Austria
"""

from django.utils.translation import ugettext_lazy as _

# after ISO_3166-2
PROVINCE_CHOICES = (
	('9', _(u'Wien')),		# Vienna
	('1', _(u'Burgenland')),
	('2', _(u'Kärnten')),		# Carinthia
	('3', _(u'Niederösterreich')),	# Lower Austria
	('4', _(u'Oberösterreich')),	# Upper Austria
	('5', _(u'Salzburg')),
	('6', _(u'Steiermark')),	# Styria
	('7', _(u'Tirol')),		# Tyrol
	('8', _(u'Vorarlberg')),
)

# alternative keys using initials (not used in forms)
PROVINCE_CHOICES_INITIALS = (
	('W', _(u'Wien')),		# Vienna
	('B', _(u'Burgenland')),
	('K', _(u'Kärnten')),		# Carinthia
	('N', _(u'Niederösterreich')),	# Lower Austria
	('O', _(u'Oberösterreich')),	# Upper Austria
	('S', _(u'Salzburg')),
	('St', _(u'Steiermark')),	# Styria
	('T', _(u'Tirol')),		# Tyrol
	('V', _(u'Vorarlberg')),
)

