"""
>>> from django.forms import * 
>>> from django.forms.util import ErrorList

Custom error_class and form using it

>>> class ErrList(list):
...    def __unicode__(self):
...        return u"<div>%s</div>" % ', '.join([unicode(msg) for msg in self])
>>> class ValidationTest(Form):
...     first_name = CharField(required=True)
...     def clean(self):
...         raise ValidationError, "Never correct"
        
#Instance with missing field using custom class
>>> vt = ValidationTest(error_class=ErrList, data={})
>>> vt.errors[NON_FIELD_ERRORS].__unicode__()
u'<div>Never correct</div>'
>>> vt.errors['first_name'].__unicode__()
u'<div>This field is required.</div>'

Classes extending ErrorList need to be aware that field error
messages are translation objects:
>>> from django.utils.translation import ugettext_lazy as _
>>> t =  _('This field is required')
>>> type(t)
<class 'django.utils.functional.__proxy__'>
>>> t + "x"
u'This field is requiredx'
>>> ', '.join([t,t,t,t])
Traceback (most recent call last):
...
TypeError: sequence item 0: expected string, __proxy__ found
>>> ', '.join([unicode(t), unicode(t)])
u'This field is required, This field is required'

"""

import doctest
doctest.testmod()







