import unittest
from django.utils.translation import strip_blocktrans

class BlockTransStripTest(unittest.TestCase):
    def testOneLine(self):
        s1 = "One Line No Indent"
        
        s1_expected = "One Line No Indent"
        
        self.assertEquals(s1_expected,strip_blocktrans(s1))

    def testEmpty(self):
        s1 = ""
        
        s1_expected = ""
        
        self.assertEquals(s1_expected,strip_blocktrans(s1))

    def testStrip(self):
        s1 = """
        8 spaces
        8 spaces
        8 spaces
        
        """
        
        s1_expected = """8 spaces
8 spaces
8 spaces"""
        
        self.assertEquals(s1_expected,strip_blocktrans(s1))
        
    def testStrip2(self):
        "If the first line has no indentation, the remaining lines are not touched."
        
        s1 = """not indented
        8 spaces
        8 spaces
        
        """
        
        s1_expected = """not indented
        8 spaces
        8 spaces"""
        
        self.assertEquals(s1_expected,strip_blocktrans(s1))
        
    def testStrip2Tabs(self):
        "If the first line has no indentation, the remaining lines are not touched."
        
        s1 = """not indented
		2 tabs
		2 tabs
        
        """
        
        s1_expected = """not indented
		2 tabs
		2 tabs"""
        
        self.assertEquals(s1_expected,strip_blocktrans(s1))
         
       
    def testStrip3(self):
        "If a single line has less indentation then the first line, the indetation is stripped anyway." 
        
        s1 = """
        8 spaces
       7 spaces
        8 spaces
        
        """
        
        s1_expected = """8 spaces
7 spaces
8 spaces"""
        
        self.assertEquals(s1_expected,strip_blocktrans(s1))

    def testStrip4Tabs(self):
        "Only indetation equal to the indentation of the first line is stripped, any line with additional spacing is stripped up to the indetation of the first line. This is indentation with tabs."
        
        s1 = """
		2 tabs
			3 tabs
		2 tabs
        
        """
        
        s1_expected = """2 tabs
	3 tabs
2 tabs"""
        
        self.assertEquals(s1_expected,strip_blocktrans(s1))
       
           
    def testStrip5Mixed(self):
        
        s1 = """
    4 spaces
	    8 spaces
	        12 spaces
        
        """
        
        s1_expected = """4 spaces
 8 spaces
     12 spaces"""
        
        self.assertEquals(s1_expected,strip_blocktrans(s1))
       
         
    def testStrip4Mixed(self):
        "Only indetation equal to the indentation of the first line is stripped, any line with additional spacing is stripped up to the indetation of the first line. This is mixed indetation with tabs and spaces."
        
        s1 = """
    4 spaces
	    1 tab and 4 spaces
		    2 tabs and 4 spaces
        
        """
        
        s1_expected = """4 spaces
 1 tab and 4 spaces
  2 tabs and 4 spaces"""
        
        self.assertEquals(s1_expected,strip_blocktrans(s1))
       

    def testStrip4(self):
        "Only indetation equal to the indentation of the first line is stripped, any line with additional spacing is stripped up to the indetation of the first line."
        
        s1 = """
        8 spaces
            12 spaces
        2 tabs
        
        """
        
        s1_expected = """8 spaces
    12 spaces
2 tabs"""
        
    def testStrip4(self):
        "Only indetation equal to the indentation of the first line is stripped, any line with additional spacing is stripped up to the indetation of the first line."
        
        s1 = """
        8 spaces
            12 spaces
        8 spaces
        
        """
        
        s1_expected = """8 spaces
    12 spaces
8 spaces"""
        
        self.assertEquals(s1_expected,strip_blocktrans(s1))
       
       
if __name__ == '__main__':
	unittest.main()
