from django.http import HttpResponse
from friends.people.models import person, Blog
from django.shortcuts import render_to_response, get_object_or_404
from friends.quotes.models import quote
from datetime import datetime
from django import forms


def index(request):
    pList = person.objects.all()
    return render_to_response('people/person_index.html', {'pList':pList})

def details(request, pID='0', opts=()):
    rDict = {}
    p = get_object_or_404(person, pk=pID)
    rDict['p'] = p
    quotes= quote.objects.all()
    rDict['quotes']=quotes
    return render_to_response('people/person_details.html',rDict)

def person_form(request, pID='0'):
    PersonForm = forms.form_for_model(person)
    f = PersonForm()
    message = 'Unknown Request'
    p= get_object_or_404(Person, pk=pID)

    if request.method == 'GET':
        PersonForm = forms.form_for_instance(p)
        f=PersonForm()
        message= 'Editing person %s ' % p.name

    if request.method == 'POST':
        if request.POST['submit'] == 'update':
            message = 'Update Request for %s ' % p.name

    return render_to_response(
        'people/person_form.html',
        {'pForm':f,
         'message':message})
# Create your views here.
