
# Programma om de gebruikers afkortingen te maken
# 18/jul/2007 15:44 Benedict   
#   We krijgen sinds de svn update van Django naar versie 5722 de volgende fout op strings
#   Exception unknown encoding: cp0
#   Strings expliciet casten naar str() lost dat probleem op.
#   Het probleem deed zich niet voor als 't programma via de console liep
#   Versie 5600 bevat de merging van de unicode tree

import random
import logging
logger = logging.getLogger('user_creation')

class NameException(Exception):
    pass

class UserCreation(object):
    """
    """
    EXCEPTION_1 = ["Van den", "Van der", "Vander", "Vanden", "Van de", "Vande"]
    EXCEPTION_Y = ["ey", "ay", "oy"]
    EXCEPTION_2 = ["Ver", "Den", "Van"]
    VOWEL = ["a","e","i","o","u","y"]
    CONSENANT = [chr(char) for char in xrange(ord("a"),ord("z")+1) if chr(char) not in VOWEL ]

    def __init__(self):
        """
        We need at least the voornaam & achternaam
        """
        self.voornaam = None
        self.achternaam = None

    def create_all(self, ask_input=False):
        """
        @param ask_input: Ask for the name on the prompt or assume the names have been set
        @type ask_input: boolean
        """
        if ( ask_input == True ):
            self.read_data()
        
        if ( self.voornaam != None and self.achternaam != None ):
            self.clean_names()
            self.create_initials()
            self.create_email()
            self.create_logins()
            self.create_password()
            self.report()
        else:
            print "Geen geldige voor -en/of achternaam"

    def read_data(self):
        """
        Read voornaam & achternaam from the prompt
        """
        self.voornaam = raw_input("Geef de gebruik voornaam: ")
        if ( self.voornaam == None or len(self.voornaam) < 1 ):
            raise NameException("De gebruiker voornaam moet ingevuld worden en langer zijn dan 1 karakter")

        self.achternaam = raw_input("Geef de gebruik achternaam: ")
        if ( self.achternaam == None or len(self.achternaam) < 1 ):
            raise NameException("De gebruiker achternaam moet ingevuld worden en langer zijn dan 1 karakter")

    def clean_names(self):
        """
        Strip spaces and tabs from the names
        """
        self.voornaam = self.voornaam.strip()
        self.achternaam = self.achternaam.strip()

        self.voornaam_clean = self.voornaam.lower()
        self.voornaam_clean = ''.join(self.voornaam_clean.split())

        self.achternaam_clean = self.achternaam.lower()
        self.achternaam_clean = ''.join(self.achternaam_clean.split())

    def create_email(self):
        """
        Compose an email adres
        """
        try:
            self.email = "%s.%s@vdl.be" % (self.voornaam_clean, self.achternaam_clean)
            self.email = self.email.strip().lower()
        except Exception, e:
            self.email = ""

    def create_logins(self):
        """
        Make the logons for the system and the internet
        """
        try:
            self.login_systeem = "%s.%s" % (self.voornaam_clean, self.achternaam_clean)
            self.login_internet = "%s%s" % (self.voornaam_clean, self.achternaam_clean)
        except Exception, e:
            self.login_systeem = ""
            self.login_internet = ""

    def _create_exception_1(self, naam):
        """
        Exception 1: Name starts with 1 of these: EXCEPTION_1
        @param naam: The EXCEPTION_1 the lastname starts with
        @type naam: string
        """
        try:
            #print "Uitzondering 1: Naam %s start met %s." % (str(self.achternaam), str(naam))
            first = self.voornaam[:1].upper()
            mid = "VD"
            last = self.achternaam_clean[len(naam):].strip()[:1].upper()
        except Exception, e:
            print "Error in _create_exception_1. Exception %s." % str(e)
            first = last = "-"
            mid = "--"
        return first + mid + last

    def _create_exception_2(self, password_chars):
        """
        Exception 2: name start with a string from EXCEPTION_2
        """
        try:
            one, two, four = password_chars
            for naam in UserCreation.EXCEPTION_2:
                naam = naam.lower() 
                if ( self.achternaam_clean.startswith(naam) ):
                    if ( naam != "den" or
                         naam == "den" and (self.achternaam_clean[len("den")] in UserCreation.CONSENANT ) ):
                        print "Uitzondering 2: Naam %s start met %s." % (str(self.achternaam), str(naam))
                        three = self.achternaam_clean[len(naam):].strip()[:1].upper()
                        self.initialen = str(one + two + three + four)
                        return
        except Exception, e:
            print "Error in _create_exception_2. Exception %s." % str(e)
            logger.debug("Error in _create_exception_2. Exception %s." % str(e))
            self.initialen = "----"

    def _create_exception_3(self, password_chars):
        """
        Exception 3: name starts with a vowel
        """
        try:
            one, two, four = password_chars
            for klinker in UserCreation.VOWEL:
                if ( self.achternaam_clean.startswith(klinker) ):
                    print "Uitzondering 3: Naam %s start met %s." % (str(self.achternaam), str(klinker))
                    #print "Achternaam start met klinker %s " % klinker
                    for letter in self.achternaam_clean:
                        if ( letter in UserCreation.CONSENANT ):
                            three = letter.upper()
                            self.initialen = str(one + two + three + four)
                            return
        except Exception, e:
            print "Error in _create_exception_3. Exception %s." % str(e)
            logger.debug("Error in _create_exception_3. Exception %s." % str(e))
            self.initialen = "----"

    def _create_exception_4(self, password_chars):
        """
        Exception 4: No consenant between 1st letter and last consenant
        """
        try:
            consenant = False
            laatste_consenant = self._find_last_cons(self.achternaam_clean)
            in_between = self.achternaam_clean[1:laatste_consenant-1]
            one, two, four = password_chars
            for letter in in_between:
                if ( letter in UserCreation.CONSENANT ):
                    consenant = True
                    break
            if ( consenant == False ):
                three = self.achternaam_clean[1].upper()
                print "Uitzondering 4: Naam %s." % str(self.achternaam)
                self.initialen = str(one + two + three + four)
                return
        except Exception, e:
            print "Error in _create_exception_4. Exception %s." % str(e)
            logger.debug("Error in _create_exception_4. Exception %s." % str(e))
            self.initialen = "----"

    def create_password(self):
        """
        Create a random password for the user
        """
        try:
            # we need at least 5 chars
            # in case of names like Harm-Wouter, remove the -
            # 
            voornaam = (self.voornaam[:5].lower()).replace("-","")
            self.paswoord = voornaam
            length_voornaam = len(voornaam)
            if ( length_voornaam < 5 ):
                still_needed = 5 - length_voornaam
                self.paswoord += self.achternaam_clean[:still_needed]
            if ( len(self.paswoord) < 5 ):
                raise Exception("Ik kan geen 5 karakters gebruiken voor de naam omdat ze te kort zijn.")
            numbers =  [str(random.randint(0,9)) for nr in xrange(0,6) ]
            self.paswoord += "".join(numbers)
        except Exception, e:
            print "Error in create_password. Exception %s." % str(e)
            self.paswoord = "UNDEFINED"
        return self.paswoord

    def _y_is_consonant(self):
        """
        Remove y from VOWEL and add to CONSENANT
        """
        try:
            UserCreation.VOWEL = UserCreation.VOWEL[:-1]
            UserCreation.CONSENANT.insert(len(UserCreation.CONSENANT)-1,"y")
        except Exception, e:
            raise Exception("_y_is_consonant problem: %s" % str(e) )

    def _find_last_cons(self,search):
        """
        Find the last consenant
        """
        try:
            pos = len(search)
            for letter in search[::-1].lower():
                if letter in UserCreation.CONSENANT:
                    return pos
                pos = pos-1
        except Exception, e:
            raise Exception("_find_last_cons problem: %s" % str(e) )
        return pos

    def _find_second_cons(self,search):
        """
        Find the 2nd last consenant
        """
        pos = 0
        nr = 0
        try:
            for letter in search.lower():
                if letter in UserCreation.CONSENANT:
                    nr+=1
                if ( nr == 2 ): break
                pos += 1
        except Exception, e:
            raise Exception("_find_second_cons problem: %s" % str(e) )
        return pos

    def _is_y_consenant(self):
        """
        Find out if there are combinations with y that force y to be a consenant
        """
        try:
            for letter_combo in UserCreation.EXCEPTION_Y:
                #print "Zoeken %s in %s " % (letter_combo, self.achternaam_clean)    
                if (self.achternaam_clean.find(letter_combo) != -1):
                    #print "%s gevonden. y is een CONSENANT" % letter_combo
                    self._y_is_consonant()
                    break
        except Exception, e:
            raise Exception("_is_y_consenant problem: %s" % str(e) )
        
    def create_initials(self):
        """
        Create initials
        """     
        self.initialen = ""

        UserCreation.VOWEL = ["a","e","i","o","u","y"]
        UserCreation.CONSENANT = [chr(char) for char in xrange(ord("a"),ord("z")+1) if chr(char) not in UserCreation.VOWEL ]

        # Uitzondering 1
        # Achternaam start met Van
        # Creatie volledig paswoord
        try:
            for naam in UserCreation.EXCEPTION_1:
                naam = naam.lower()
                if ( self.achternaam_clean.startswith(naam) ):
                    print "Uitzondering 1: Naam %s start met %s." % (str(self.achternaam),str(naam))
                    self.initialen = self._create_exception_1(naam)
                    return
        except Exception, e:
            print "Error in exception 1. Exception %s." % str(e)
            logger.debug("Error in exception 1. Exception %s." % str(e))
            self.initialen = "----"

        # Detectie of we een y hebben die we als CONSENANT of klinker beschouwen
        self._is_y_consenant()

        #print "CONSENANT ",str(UserCreation.CONSENANT)
        #print "VOWEL ",str(UserCreation.VOWEL)

        # Kies de 1ste, 2de & 4de letter
        one = self.voornaam[:1].upper()
        two = self.achternaam[:1].upper()
        four = ""
        for letter in self.achternaam_clean[::-1]:
            if letter in UserCreation.CONSENANT:
                four = letter.upper()
                #print "Laatste CONSENANT achternaam %s" % letter
                break

        password_chars = [one, two, four]

        # Uitzondering 2
        # Achternaam start met Van, Den (gevolgd door CONSENANT) of Ver
        # Standaard, enkel de 3e verschilt
        self._create_exception_2(password_chars)
        if ( len(self.initialen) == 4 ): return

        # Uitzondering 3
        # Achternaam start met een klinker
        # Standaard, enkel de 3e verschilt
        self._create_exception_3(password_chars)
        if ( len(self.initialen) == 4 ): return

        # Uitzondering 4
        # Achternaam heeft GEEN CONSENANT tussen 1ste letter en de laatste CONSENANT
        # Standaard, enkel de 3e verschilt
        self._create_exception_4(password_chars)
        if ( len(self.initialen) == 4 ): return

        # Normaal geval
        print "Geen uitzondering gevonden voor %s %s " % (str(self.voornaam),str(self.achternaam))
        #print "CONSENANT %s " % str(UserCreation.CONSENANT)
        three = self.achternaam_clean[self._find_second_cons(self.achternaam_clean)].upper()
        self.initialen = str(one + two + three + four)
        return self.initialen

    def report(self):
        """
        """
        print " "
        print " "
        print "Emailen naar Hein & de Office manager"
        print "-----8<-----8<-----8<-----8<-----8<-----8<-----8<-----8<"

        a = unicode('Paswoord: %s ' % self.paswoord, 'ascii')
        print a
        #print u"Paswoord: %s " % self.paswoord

        print "-----8<-----8<-----8<-----8<-----8<-----8<-----8<-----8<"
        print " "
        print " "
        print "Emailen naar Hein, Martin, Barbara"
        print "-----8<-----8<-----8<-----8<-----8<-----8<-----8<-----8<"
        print "Initialen: %s " % str(self.initialen)
        print "Login systeem: %s " % str(self.login_systeem)
        print "Login internet/surfen: %s " % str(self.login_internet)
        print "Email: %s " % str(self.email)
        print "CCS nummer: "
        print "Telefoon nummer: "
        print "-----8<-----8<-----8<-----8<-----8<-----8<-----8<-----8<"

if __name__=="__main__":
    u = UserCreation()
    u.create_all(True)
