from django.conf import settings
from django.contrib.sites.models import Site

class SubdomainURLsMiddleware:
    """ change the URL conf based on the subdomain in the request """
    
    def process_request(self, request):
        # Split the domain into it's parts, remove the main part of the domain 
        # from the requested host, and we're left with one variable: 'subdomain'.
        # We also strip out the 'www.' non web-savvy users often type 'www' in 
        # front of every website they visit.
        django_site = Site.objects.get_current()
        domain_parts = django_site.domain.split(".")
        domain = ".".join(domain_parts[1:])
        subdomain = request.META['HTTP_HOST'].replace(domain, '').replace('.', '').replace('www', '')
        try:
            #you'll have to define a map of subdomains -> urlconfs in your settings
            if subdomain in settings.DOMAINS_URLCONF:
                request.__setattr__('urlconf',
                                    settings.DOMAINS_URLCONF[subdomain])
        except: {}
        return None
