from django.conf import settings
from django.contrib.sites.models import Site

class SubdomainURLsMiddleware:
    """ change the URL conf based on the subdomain in the request """
    
    def process_request(self, request):
        # strip out the 'www.' non web-savvy users often type 'www' in 
        # front of every website they visit.
        domain = Site.objects.get_current().domain
        subdomain = request.META['HTTP_HOST'].replace(domain, '').replace('.', '').replace('www', '')
        try:
            #you'll have to define a map of subdomains -> urlconfs in your settings
            if subdomain in settings.DOMAINS_URLCONF:
                request.__setattr__('urlconf',
                                    settings.DOMAINS_URLCONF[subdomain])
        except: {}
        return None
