## 
## DivForm class
## 
## Author: Michal Ludvig <michal@logix.cz>
##         http://www.logix.cz/michal
##

from django import newforms as forms

class DivErrorList(forms.util.ErrorList):
    """
    Helper class that wraps error lists into <div> tags for DivForm
    """
    def as_div(self):
        if not self: return u''
        return u'<div class="errorlist">%s</div>' % ''.join([u'<div class="error">%s</div>' % e for e in self])

    def __str__(self):
        return self.as_div()

    def __unicode__(self):
        return self.as_div()


class DivForm(forms.Form):
    """
    DivForm class that can be used instead of forms.Form
    to get output fields wrapped in <div> tags instead of 
    those ugly table or <p> tags.
    """
    def as_div(self):
        return self._html_output(u'<div class="form_row"><div class="label">%(label)s</div><div class="field">%(field)s</div><div class="errors">%(errors)s</div><div class="help">%(help_text)s</div></div>',
            u'<div class="error">%s</div>', '</div>', u'%s', False,
            DivErrorList)

    def __str__(self):
        return self.as_div()

    def __unicode__(self):
        return self.as_div()
