from django.core.serializers import serialize, deserialize
from mysite.polls.models import Poll
from datetime import datetime

from django.core.validators import ValidationError

from unittest import TestCase

class JsonSerializerShouldDealWithNonePrimaryKeysTest(TestCase):
  def testAlreadyHandlesNonNullPKs(self):
    m = self.model()
    m.save()

    try:
      list(deserialize('json', serialize('json', [m])))[0].object
    except ValidationError:
      self.fail()

  def testBlowsUpBecauseNoneInAStringIsNotNull(self):
    m = self.model()
    # no save.

    serialized = serialize('json', [m])
    self.assertFalse('null' in serialized)
    self.assertTrue('"None"' in serialized)

    try:
      list(deserialize('json', serialized))[0].object
      self.fail()
    except ValidationError, va:
      self.assertEquals(['This value must be an integer.'], va.messages)

  def model(self):
    return Poll(question="What's up?", pub_date=datetime.now())
