from django import newforms as forms
from django.newforms.util import ValidationError

class RegisterForm(forms.Form):
    def get_expression(self):
	return 'seven', str(7)

    def __init__(self, session, *args, **kwargs):
	super(RegisterForm, self).__init__(*args, **kwargs)
	self.session = session
	self.exp, self.res = self.get_expression()
	self.fields['expression'].label = self.exp.capitalize()

    def __del__(self):
	self.session['expression_result'] = self.res

    expression = forms.RegexField('^\d+$', max_length=3, label='', help_text=_('Enter 7'))
    
    def clean_expression(self):
	if self.cleaned_data['expression'] != self.session['expression_result']:
	    raise ValidationError(_('Invalid result!'))
	return self.cleaned_data['expression']
