#escape_markdown.py

from django.template import Library

register = Library()

def escape_without_markdown_syntax(text):
	"""	This function escapes '<', '>', '&' into text in HTML-entities
		For example:
			> > I said, give me <more> M&M's
			> Nobody gives you more M&M's!
			You are fucking greedy!
	
		Translates into
			> > I said, give me &gt;more&lt; M&amp;M's
			> Nobody gives you more M&amp;M's!
			___You are fucking greedy!___
	
		After that, Markdown filter can translate it into
			<blockquote> 
				<blockquote> I said, give me &gt;more&lt; M&amp;M's</blockquote>
			<blockqoute> Nobody gives you more M&amp;M's!</blockquote>
			<strong>You are fucking greedy!</strong>
		
		For correctly using this filter write "|escape_markdown" before using Markdown filter
		filters:
			And now we present you a Markdown: <fieldset>{{ text|escape_markdown|markdown }}</fieldset>
		
		Also it fixes Markdown error with backslash '\'

"""
	lines = []
	for s in text.split('\n'):
		i = 0
		while i < len(s) and (s[i] == ' ' or s[i] == '>') :
			i+=1
		str1 = s[0:i]
		str2 = s[i:]
		str2 = str2.replace('&','&amp;')
		str2 = str2.replace('>','&gt;')
		str2 = str2.replace('<','&lt;')
		str2 = str2.replace('\\','&#92;')
		lines.append(str1 + str2)
	return '\n'.join(lines)

register.filter('mrakdown', escape_without_markdown_syntax) # Смешная версия названия фильтра :)
                                                            # It's fun version of filter name
                                                            # for russians users

register.filter('escape_markdown', escape_without_markdown_syntax)


def delete_markdown_quoted_text(text):
	lines = []
	for s in text.split('\n'):
		if len(s) == 0:
			lines.append('')
			continue
		i = 0
		while i < len(s) and s[i] == ' ':
			i+=1
		if s[i] == '>':
			continue
		else:
			lines.append(s)
	return '\n'.join(lines)

register.filter('delete_markdown_blockquotes', delete_markdown_quoted_text) 
