class Alias(models.Model):
    address = models.CharField(maxlength=255, blank=True, null=True)
    domain = models.ForeignKey(Domain)
    enabled = models.BooleanField('Enabled',default=True)
    recipients = models.ManyToManyField(Recipient, filter_interface=models.HORIZONTAL)

    def __str__(self):
        return "%s@%s" % (self.address, self.domain.name)

    class Meta:
        ordering = ('domain', 'address')

    class Admin:
        list_display = ('__str__', 'enabled')
        list_filter = ('domain',)
        ordering = ('domain', 'address')

