from django.db import models
from django.db.models import Q


class Measure(models.Model):

    id = models.AutoField(
        primary_key=True,
        verbose_name="Key",
    )
    code = models.CharField(
        max_length=5,
        unique=True,
        verbose_name="Code",
        error_messages={"unique": "Err msg."},
    )

    def __str__(self):
        return self.code


class MyModel(models.Model):

    id = models.BigAutoField(primary_key=True, editable=False)
    name = models.CharField(max_length=1000, verbose_name="Name")
    measure = models.ForeignKey(
        Measure,
        related_name="mymodel_measure",
        on_delete=models.SET_NULL,
        null=True,
        blank=True,
        verbose_name="Measure",
    )

    def __str__(self):
        return self.name

    class Meta:
        constraints = [
            models.UniqueConstraint(
                fields=["name"],
                name="mymodel_unique_name_measure_null",
                condition=Q(measure__isnull=True),
                violation_error_message="Error message for null",
            ),
            models.UniqueConstraint(
                fields=["name", "measure"],
                name="mymodel_unique_name_measure_not_null",
                condition=Q(measure__isnull=False),
                violation_error_message="Error message for not null",
            ),
        ]
